#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.LanzCli as LanzCli # pylint: disable=consider-using-from-import
from CliToken.Clear import clearKwNode
from CliToken.Ip import ipMatcherForClear
from CliToken.Ipv6 import ipv6MatcherForClear
import CliToken.Lanz as Lanz # pylint: disable=consider-using-from-import
import BasicCliModes

#--------------------------------------------------------------------------------
# clear queue-monitor length statistics
#--------------------------------------------------------------------------------
class ClearQueueMonitorLengthStatisticsCmd( CliCommand.CliCommandClass ):
   syntax = 'clear queue-monitor length statistics'
   data = {
      'clear' : clearKwNode,
      'queue-monitor' : Lanz.nodeQueueMonitor,
      'length' : Lanz.matcherLength,
      'statistics' : Lanz.nodeStatistics,
   }

   handler = LanzCli.clearQMonitorLengthStatistics

BasicCliModes.EnableMode.addCommandClass( ClearQueueMonitorLengthStatisticsCmd )

#--------------------------------------------------------------------------------
# clear queue-monitor streaming counters ( ip | ipv6 ) access-list
#--------------------------------------------------------------------------------
class ClearQueueMonitorStreamingCountersIpAccessListCmd(
      CliCommand.CliCommandClass ):

   syntax = 'clear queue-monitor streaming counters ( ip | ipv6 ) access-list'
   data = {
      'clear' : clearKwNode,
      'queue-monitor' : Lanz.nodeQueueMonitor,
      'streaming' : Lanz.nodeStreaming,
      'counters' : 'Clear IP access list counters',
      'ip' : ipMatcherForClear,
      'ipv6' : ipv6MatcherForClear,
      'access-list' : 'Named access-list',
   }

   @staticmethod
   def handler( mode, args ):
      if 'ip' in args:
         LanzCli.clearQMonStreamingIpAclCounters( mode )
      else:
         LanzCli.clearQMonStreamingIpv6AclCounters( mode )

BasicCliModes.EnableMode.addCommandClass(
   ClearQueueMonitorStreamingCountersIpAccessListCmd )
