# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel
import Ark

class MonitorSystemShow( CliModel.Model ):
   featureEnabled = CliModel.Bool( help="Memory Exhaustion feature is enabled" )
   currLowMemModeStatus = CliModel.Bool( help="The system is currently under Memory"
                                              " Exhaustion" )
   lastLowMemModeEntered = CliModel.Float( help="Time of last entrance in Memory "
                                                "Exhaustion", optional=True )
   lastLowMemModeExited = CliModel.Float( help="Time of last exit from Memory "
                                               "Exhaustion", optional=True )
   lowMemModeCount = CliModel.Int( help="Number of times the system has "
                                        "entered Memory Exhaustion" )
   def render( self ):
      print( "Memory Exhaustion feature enabled:", self.featureEnabled )
      print( "System currently in Memory Exhaustion:", self.currLowMemModeStatus )
      print( "Total number of times system entered Memory Exhaustion:",
             self.lowMemModeCount )

      if self.lastLowMemModeEntered:
         lastLowMemModeEntered = (
                     Ark.utcTimeRelativeToNowStr( self.lastLowMemModeEntered ) )
         print( "Last time entered in Memory Exhaustion:", lastLowMemModeEntered )
      if self.lastLowMemModeExited:
         lastLowMemModeExited = (
                     Ark.utcTimeRelativeToNowStr( self.lastLowMemModeExited ) )
         print( "Last time exited from Memory Exhaustion:", lastLowMemModeExited )

