#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliToken.Clear
from CliPlugin import ConfigMgmtMode
import ShowCommand
import Tac

#-------------------------------------------------------------------------------
# "show management ldap"
#-------------------------------------------------------------------------------
class MgmtLdapCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management ldap'
   data = {
      'management': ConfigMgmtMode.managementShowKwMatcher,
      'ldap': 'LDAP server statistics',
   }
   handler = "LdapHandler.showLdap"
   cliModel = "LdapModel.ShowLdapModel"

BasicCli.addShowCommandClass( MgmtLdapCmd )

#-------------------------------------------------------------------------------
# "clear aaa counters ldap" in enable mode
#-------------------------------------------------------------------------------
class ClearAaaCountersLdapCmd( CliCommand.CliCommandClass ):
   syntax = 'clear aaa counters ldap'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'aaa': 'Clear AAA information',
      'counters': 'Clear AAA counters',
      'ldap': 'Clear LDAP server statistics'
   }
   handler = "LdapHandler.clearCounters"

BasicCli.EnableMode.addCommandClass( ClearAaaCountersLdapCmd )
