#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import BasicCli
import CliMatcher
from CliPlugin import IpAddrMatcher
from CliPlugin.IraIpModel import VrfLdpIpRoutes
from CliToken.Ipv4 import ipv4MatcherForShow
import ShowCommand

matcherRib = CliMatcher.KeywordMatcher( 'rib',
      helpdesc='Routing Information Base commands' )
matcherRoute = CliMatcher.KeywordMatcher( 'route',
      helpdesc='Routing Information Base routes' )
ipPrefixMatcher = IpAddrMatcher.ipPrefixExpr(
   'Match this IP address', 'Match this subnet mask',
   'Match this IP prefix', partial=True,
   overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO )

#--------------------------------------------------------------------------------
# show rib system-tunneling-ldp-rib route ipv4 [ PREFIX ]
#--------------------------------------------------------------------------------
class LdpRibShortcutCmd( ShowCommand.ShowCliCommandClass ):
   syntax = "show rib system-tunneling-ldp-rib route ipv4 [ PREFIX ]"

   data = { 'rib': matcherRib,
            'system-tunneling-ldp-rib': "Route details for LDP over RSVP resolution",
            'route': matcherRoute,
            'ipv4': ipv4MatcherForShow,
            'PREFIX': ipPrefixMatcher
   }

   cliModel = VrfLdpIpRoutes
   handler = "LdpRibRouteShowCliHandler.handlerLdpRibShortcutCmd"

BasicCli.addShowCommandClass( LdpRibShortcutCmd )
