#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from CliPlugin import IntfCli
import ConfigMount, LazyMount

config = None
bridgingHwCapabilities = None

#-------------------------------------------------------------------------------
# The LoopProtectIntf class is used to remove the LoopProtect IntfConfig object when
# an interface is deleted. The Intf class will create a new instance of DhcpRelayIntf
# and call destroy when the interface is deleted
#-------------------------------------------------------------------------------
class LoopProtectIntf( IntfCli.IntfDependentBase ):
   #----------------------------------------------------------------------------
   # resets the IntfConfig object for this interface if it exists.
   #----------------------------------------------------------------------------
   def setDefault( self ):
      del config.intfExclude[ self.intf_.name ]

#-------------------------------------------------------------------------------
# add show tech support
#-------------------------------------------------------------------------------
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2015-08-03 17:02:43',
   cmds=[ 'show loop-protection detail' ],
   cmdsGuard=lambda: bridgingHwCapabilities.loopProtectSupported )

def Plugin( entityManager ):
   global config, bridgingHwCapabilities

   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             "bridging/hwcapabilities",
                                             "Bridging::HwCapabilities", "r" )

   IntfCli.Intf.registerDependentClass( LoopProtectIntf )
