#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# - show  loop-protection [ detail ]
# - show  loop-protection vlan VLANSET
# - show  loop-protection counters
#-------------------------------------------------------------------------------

# pylint: disable=ungrouped-imports

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.VlanCli as VlanCli # pylint: disable=consider-using-from-import

matcherLoopProtection = CliMatcher.KeywordMatcher( 'loop-protection', 
      helpdesc='Loop Protection status' )

class LoopProtectionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show loop-protection [ detail ]'
   data = {
      'loop-protection': matcherLoopProtection,
      'detail': 'Loop Protection detailed status',
   }
   
   handler = "LoopProtectShowCommandsHandler.generateLoopProtectShowModel"
   cliModel = "LoopProtectModels.LoopProtectShow"

BasicCli.addShowCommandClass( LoopProtectionCmd )

class LoopProtectionCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show loop-protection counters'
   data = {
      'loop-protection': matcherLoopProtection,
      'counters': 'Counters for loop protection messages',
   }
   
   handler = "LoopProtectShowCommandsHandler.generateLoopProtectCountersModel"
   cliModel = "LoopProtectModels.LoopProtectCounters"

BasicCli.addShowCommandClass( LoopProtectionCountersCmd )

class LoopProtectionVlanVlansetCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show loop-protection vlan VLANSET'
   data = {
      'loop-protection': matcherLoopProtection,
      'vlan': 'VLANs to see loop protection information on',
      'VLANSET': VlanCli.vlanSetMatcher, 
   }
   
   handler = "LoopProtectShowCommandsHandler.generateLoopProtectVlanModel"
   cliModel = "LoopProtectModels.LoopProtectVlan"

BasicCli.addShowCommandClass( LoopProtectionVlanVlansetCmd )
