# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliPlugin.XcvrConfigCli import Layer1MonitorMode

class MacFaultLoggingCmd( CliCommand.CliCommandClass ):
   syntax = 'logging mac fault'
   noOrDefaultSyntax = 'logging mac fault'
   data = {
      'logging': 'Configure logging',
      'mac': 'Configure mac logging',
      'fault': 'Enable mac fault logging'
   }

   handler = "MacFaultLoggingCliHandler.MacFaultLoggingCmdHandler"
   noOrDefaultHandler = "MacFaultLoggingCliHandler.MacFaultLoggingCmdNoHandler"

Layer1MonitorMode.addCommandClass( MacFaultLoggingCmd )
