# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
from CliPlugin.BridgingCli import warnMacTableUnsupportedUFTModeHook
from CliPlugin.MacFlapCliModels import MacFlapStatus, MacFlapDetectionWindow

macFlapConfig = None

#---------------------------------------------------------------------
# "show mac address-table notification host-flap logging"
#---------------------------------------------------------------------

def doShowMacFlapStatus( mode, args ):
   return MacFlapStatus( status=macFlapConfig.enabled )

#---------------------------------------------------------------------
# "show mac address-table notification host-flap detection window"
#----------------------------------------------------------------------

def doShowMacFlapDetectWindow( mode, args ):
   flapDelta = int( macFlapConfig.flapDelta )
   return MacFlapDetectionWindow( detectionWindow=flapDelta )

#----------------------------------------------------------------------
# "mac address-table notification host-flap logging"
#----------------------------------------------------------------------

def doSetMacFlapStatus( mode, args ):
   macFlapConfig.enabled = True
   # Hook is populated on Trident4 platforms to warn of conflicting configuration
   warnMacTableUnsupportedUFTModeHook.notifyExtensions( mode )

def noSetMacFlapStatus( mode, args ):
   macFlapConfig.enabled = False

#---------------------------------------------------------------------
# "mac address-table notification host-flap detection window"
#---------------------------------------------------------------------

def doSetMacFlapDetectionWindow( mode, args ):
   defaultWindow = 15
   window = args.get( 'WINDOW', defaultWindow )
   macFlapConfig.flapDelta = window
   # The cleanTableInterval multiplier is just a magic number.
   macFlapConfig.cleanTableInterval = window * 8
   # Hook is populated on Trident4 platforms to warn of conflicting configuration
   warnMacTableUnsupportedUFTModeHook.notifyExtensions( mode )

#---------------------------------------------------------------------
# "mac address-table notification host-flap detection moves"
#---------------------------------------------------------------------

def doSetMacFlapMoves( mode, args ):
   defaultFlapMoves = 5
   macFlapConfig.flapMoves = args.get( 'MOVES', defaultFlapMoves )
   # Hook is populated on Trident4 platforms to warn of conflicting configuration
   warnMacTableUnsupportedUFTModeHook.notifyExtensions( mode )

def Plugin( entityManager ):
   global macFlapConfig
   macFlapConfig = ConfigMount.mount( entityManager, "macflap/config",
                                      "MacFlap::Config", "w" )
