#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import ConfigMount
from CliPlugin.MaintenanceMode import MaintenanceConfigMode
from CliPlugin import MaintenanceCliLib

maintRunnabilityConfigDir = None
maintenanceStartupDir = None

#--------------------------------------------------------------------------------
# maintenance
#--------------------------------------------------------------------------------
class MaintenanceCmd( CliCommand.CliCommandClass ):
   syntax = 'maintenance'
   data = {
      'maintenance': MaintenanceCliLib.maintenanceKwMatcher,
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( MaintenanceConfigMode )
      if mode.session_.startupConfig():
         maintenanceStartupDir.newEntity( "Tac::Dir", "enabled" )
      mode.session_.gotoChildMode( childMode )
      maintRunnabilityConfigDir.newEntity( "Tac::Dir", "enabled" )

BasicCliModes.GlobalConfigMode.addCommandClass( MaintenanceCmd )

def Plugin( entityManager ):
   global maintRunnabilityConfigDir, maintenanceStartupDir
   maintRunnabilityConfigDir = ConfigMount.mount(
      entityManager, 
      "maintenance/runnability/config", 
      "Tac::Dir", "w" )
   maintenanceStartupDir = ConfigMount.mount(
      entityManager,
      "maintenance/startup",
      "Tac::Dir", "w" )
