# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliPlugin import ConfigMgmtMode
import ConfigMount

cliConfig = None

class CliMgmtMode( ConfigMgmtMode.ConfigMgmtMode ):
   name = 'CLI configuration'

   def __init__( self, parent, session ):
      ConfigMgmtMode.ConfigMgmtMode.__init__( self, parent, session, 'cli' )

class ManagementCliConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'management cli'
   noOrDefaultSyntax = 'management cli'
   data = {
            'management': ConfigMgmtMode.managementKwMatcher,
            'cli': 'Configure CLI behavior',
          }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( CliMgmtMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      cliConfig.deprecatedCmdsSyslogMsg = False

BasicCli.GlobalConfigMode.addCommandClass( ManagementCliConfigCmd )

#------------------------------------------------------------------------------------
# command deprecated log
#------------------------------------------------------------------------------------
class CommandDeprecatedLog( CliCommand.CliCommandClass ):
   syntax = 'command deprecated log'
   noOrDefaultSyntax = syntax
   data = { 'command': 'Configure command options',
            'deprecated': 'Configure CLI behavior for deprecated commands',
            'log': 'Syslog when a deprecate command is exectued' }

   @staticmethod
   def handler( mode, args ):
      cliConfig.deprecatedCmdsSyslogMsg = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      cliConfig.deprecatedCmdsSyslogMsg = False

CliMgmtMode.addCommandClass( CommandDeprecatedLog )

def Plugin( entityManager ):
   global cliConfig
   cliConfig = ConfigMount.mount( entityManager, 'cli/config', 'Cli::Config', 'w' )
