# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: rpm MatchList-lib

import BasicCli
import ConfigMount
import CliCommand
import CliMatcher
import CliParser
import ShowCommand
import Tac
import LazyMount
import Tracing
t0 = Tracing.trace0
# --------------------------------------------------------
# Global definitions
# --------------------------------------------------------
matchListConfig = None
hwCapability = None

# --------------------------------------------------------
# Utility functions
# --------------------------------------------------------
def matchListTypeGuard( mode, token ):
   token = token.lower()
   if token == "string":
      if not hwCapability.matchListStringSupported:
         return CliParser.guardNotThisPlatform
   elif token == "prefix-ipv6":
      if not hwCapability.ipv6PrefixSupported:
         return CliParser.guardNotThisPlatform

   return None

def matchListNames( mode, context ):
   inputType = context.sharedResult[ 'TYPE' ]
   if inputType == 'string':
      return matchListConfig.matchStringList
   elif inputType == 'prefix-ipv4':
      return matchListConfig.matchIpv4PrefixList
   elif inputType == 'prefix-ipv6':
      return matchListConfig.matchIpv6PrefixList
   else:
      assert False

tokenMatchListName = \
      CliMatcher.DynamicNameMatcher( matchListNames, 'Name of match list',
                                     passContext=True )

inputTypeDict = { "string": "String input",
                  "prefix-ipv4": "IPv4 prefix",
                  "prefix-ipv6": "IPv6 Prefix"
                  }

class EnterMatchListCommandClass( CliCommand.CliCommandClass ):
   syntax = "match-list input TYPE NAME"
   noOrDefaultSyntax = syntax

   data = { "match-list": "Configure a match list to filter data",
            "input": "Data input type",
            "TYPE": CliCommand.Node(
               CliMatcher.DynamicKeywordMatcher( lambda mode: inputTypeDict ),
               storeSharedResult=True,
               guard=matchListTypeGuard ),
            "NAME": tokenMatchListName }

   handler = "MatchListCliHandlers.enterMatchList"
   noOrDefaultHandler = "MatchListCliHandlers.noMatchList"

BasicCli.GlobalConfigMode.addCommandClass( EnterMatchListCommandClass )

#------------------------------------------------------------------------------
# show match-list prefix-ipv4 [ name ]
#------------------------------------------------------------------------------
ipv4MatchListNameMatcher = CliMatcher.DynamicNameMatcher(
   lambda mode: matchListConfig.matchIpv4PrefixList,
   helpdesc='Match list name' )

class ShowIpv4MatchList( ShowCommand.ShowCliCommandClass ):
   syntax = 'show match-list prefix-ipv4 [ MATCHLIST_NAME ]'
   data = {
         'match-list': 'Show match list information',
         'prefix-ipv4': 'IPv4 prefixes',
         'MATCHLIST_NAME': ipv4MatchListNameMatcher
   }
   cliModel = "MatchListModels.MatchListInfo"
   handler = "MatchListCliHandlers.handleShowMatchListPrefixIpv4"

BasicCli.addShowCommandClass( ShowIpv4MatchList )

#------------------------------------------------------------------------------
# show match-list prefix-ipv6 [ name ]
#------------------------------------------------------------------------------
ipv6MatchListNameMatcher = CliMatcher.DynamicNameMatcher(
   lambda mode: matchListConfig.matchIpv6PrefixList,
   helpdesc='Match list name' )

class ShowIpv6MatchList( ShowCommand.ShowCliCommandClass ):
   syntax = 'show match-list prefix-ipv6 [ MATCHLIST_NAME ]'
   data = {
         'match-list': 'Show match list information',
         'prefix-ipv6': 'IPv6 prefixes',
         'MATCHLIST_NAME': ipv6MatchListNameMatcher
   }
   cliModel = "MatchListModels.MatchListInfo"
   handler = "MatchListCliHandlers.handleShowMatchListPrefixIpv6"

BasicCli.addShowCommandClass( ShowIpv6MatchList )


def Plugin( entityManager ):
   global matchListConfig, hwCapability
   matchListConfig = ConfigMount.mount( entityManager, "matchlist/config/cli",
                                        "MatchList::Config", "w" )
   hwCapability = LazyMount.mount( entityManager, "matchlist/hw/capability",
                                   "MatchList::HwCapability", "r" )
