# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliModel import Dict, Model
from IntfModels import Interface
from ArnetModel import IpGenericPrefix
from Arnet import IpGenPrefix, sortIntf

class McastBoundary( Model ):
   ''' CAPI model for show ip multicast boundary '''

   class McastBoundaryInterface( Model ):
      ''' CAPI model for multicast boundary interface '''
      boundary = Dict( keyType=IpGenericPrefix, valueType=bool,
            help="Map of denied prefix to its data plane filtering status" )

   mcastBoundaryInterfaces = Dict( keyType=Interface, 
         valueType=McastBoundaryInterface,
         help="Map of interface to multicast boundary status" )

   def render( self ):
      # pylint: disable-next=consider-using-f-string
      print( '%-15s%-21s%s' % ( 'Interface',
      'Denied Prefix', 'Data Plane Filtered' ) )
      for intf in sortIntf( self.mcastBoundaryInterfaces ):
         mBoundaryIntf = self.mcastBoundaryInterfaces[ intf ]
         for prefix in sorted( mBoundaryIntf.boundary,
                               key=lambda x: IpGenPrefix( x ).sortKey ):
            if mBoundaryIntf.boundary[ prefix ]:
               # pylint: disable-next=consider-using-f-string
               print( '%-15s%-21sYes' % ( intf, prefix ) )
            else:
               # pylint: disable-next=consider-using-f-string
               print( '%-15s%-21sNo' % ( intf, prefix ) )
