# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import TechSupportCli
from CliPlugin.MrouteCli import mcastFibIpv4SupportedGuard
from CliPlugin.GmpShowTechCli import registerShowTechMulticast, ShowTechMulticastType

import Toggles.GmpToggleLib

if Toggles.GmpToggleLib.toggleMulticastShowTechEnabled():
   showTechMcastv4Cmds = [ 'show multicast fib ipv4 vrf {} ',
                           'show multicast fib ipv4 vrf {} summary' ]
   registerShowTechMulticast( showTechMcastv4Cmds,
                              showTechMcastType=ShowTechMulticastType.vrf,
                              guard=mcastFibIpv4SupportedGuard )
else:
   TechSupportCli.registerShowTechSupportCmd(
      '2010-06-11 03:00:00',
      cmds=[ 'show multicast fib ipv4', 'show multicast fib ipv4 summary' ],
      cmdsGuard=lambda: mcastFibIpv4SupportedGuard( mode=None, token=None ) is None )

if Toggles.GmpToggleLib.toggleMulticastShowTechEnabled():
   showTechTunnelMcastCmds = [ 'show tunnel rib multicast mldp',
                               'show tunnel fib multicast mldp',
                               'show tunnel rib multicast static',
                               'show tunnel fib multicast static' ]

   if Toggles.TunnelToggleLib.toggleMvpnRsvpP2mpEnabled():
      showTechTunnelMcastCmds.append( 'show tunnel rib multicast rsvp' )
      showTechTunnelMcastCmds.append( 'show tunnel fib multicast rsvp' )

   registerShowTechMulticast( showTechTunnelMcastCmds,
                              showTechMcastType=ShowTechMulticastType.noVrf,
                              guard=mcastFibIpv4SupportedGuard )
