# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliParser
import ConfigMount
import Tac
import Tracing
from CliPlugin import IntfCli

__defaultTraceHandle__ = Tracing.Handle( 'McastDnsCli' )
mcastDnsConfig = None

IntfId = Tac.Type( 'Arnet::IntfId' )
AddressFamily = Tac.Type( 'Arnet::AddressFamily' )
LinkId = Tac.Type( 'McastDns::LinkId' )
LinkConfigKey = Tac.Type( 'McastDns::LinkConfigKey' )

#-------------------------------------------------------------------------------
# This module implements interface-specific McastDns configuration.
#
# [no|default] mdns ipv4 [ link LINK ] [ default-tag TAG ]
#-------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Add mdns commands to the 'config-if' mode.
#------------------------------------------------------------------------------
class McastDnsModelet( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      # This is a bit hacky, but there's no better way to recognize physical Ethernet
      # interfaces than to look at their name.
      return ( mode.intf.name.startswith( 'Ethernet' ) or
               mode.intf.name.startswith( 'Vlan' ) )

IntfCli.IntfConfigMode.addModelet( McastDnsModelet )

#------------------------------------------------------------------------------
# (config-if)# mdns ipv4 [ link LINK ] [ default-tag TAG ]
#------------------------------------------------------------------------------
def enableMcastDns( mode, link=None, tag=None, no=False ):
   enableMcastDnsOnIntf( mode.intf.name, no, tag, link )

def enableMcastDnsOnIntf( intfName, no, tag, link ):
   intfId = IntfId( intfName )
   key = LinkConfigKey( AddressFamily.ipv4, intfId )
   if not no:
      linkConfig = mcastDnsConfig.newLink( key )
      linkConfig.linkName = link or ''
      linkConfig.defaultTag = tag or ''
   else:
      del mcastDnsConfig.link[ key ]

class McastDnsIntf( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      enableMcastDnsOnIntf( self.intf_.name, no=True, tag=None, link=None )

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global mcastDnsConfig

   mcastDnsConfig = ConfigMount.mount( entityManager, 'mdns/config',
                                       'McastDns::Config', 'w' )
   IntfCli.Intf.registerDependentClass( McastDnsIntf )
