# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin import MvpnLibCliModels
from CliMatcher import KeywordMatcher
from McastCommonCliLib import ipv4NodeForShow
import CliToken.McastCommon
import ShowCommand
import SmashLazyMount
import Tac

mvpnVrfStatus4 = None
staticMvpnVrfStatus4 = None
evpnVrfStatus4 = None
staticEvpnVrfStatus4 = None
mvpnIntfStatus4 = None
vrfIdStatus = None

def showMvpnVrf( mode, args ):
   model = MvpnLibCliModels.MvpnVrfs()

   for vrfId, vrfIntfId in mvpnIntfStatus4.vrfIntfId.items():

      vrfEntry = vrfIdStatus.vrfIdToName.get( vrfId )
      if vrfEntry is None:
         continue

      if 'mvpn' in args:
         if ( vrfId not in mvpnVrfStatus4.mvpnVrf and
              vrfId not in staticMvpnVrfStatus4.mvpnVrf ):
            continue
      else:
         if ( vrfId not in evpnVrfStatus4.mvpnVrf and
              vrfId not in staticEvpnVrfStatus4.mvpnVrf ):
            continue

      pmsisModel = MvpnLibCliModels.MvpnVrfPmsis()
      pmsisModel.pmsis.append( vrfIntfId.pmsiIntfId )
      model.vrfs[ vrfEntry.vrfName ] = pmsisModel

   return model

#------------------------------------------------------------------------------------
# show mvpn ipv4 vrf
#------------------------------------------------------------------------------------
class MvpnIpv4VrfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mvpn ipv4 vrf'
   data = {
      'mvpn' : 'Multicast VPN',
      'ipv4' : ipv4NodeForShow,
      'vrf' : 'VRF',
   }
   handler = showMvpnVrf
   cliModel = MvpnLibCliModels.MvpnVrfs

BasicCli.addShowCommandClass( MvpnIpv4VrfCmd )

evpnForShow = KeywordMatcher( 'evpn', helpdesc="Multicast EVPN information" )
mplsForShow = KeywordMatcher( 'mpls', helpdesc="MPLS information" )

#------------------------------------------------------------------------------------
# show multicast ipv4 evpn mpls vrf
#------------------------------------------------------------------------------------
class ShowMulticastEvpnMpls( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast ipv4 evpn mpls vrf'

   data = {
      'multicast': CliToken.McastCommon.multicastMatcherForShow,
      'ipv4' : ipv4NodeForShow,
      'evpn': evpnForShow,
      'mpls' : mplsForShow,
      'vrf' : 'VRF',
   }

   handler = showMvpnVrf
   cliModel = MvpnLibCliModels.MvpnVrfs

BasicCli.addShowCommandClass( ShowMulticastEvpnMpls )

def Plugin( em ):
   global mvpnIntfStatus4
   global mvpnVrfStatus4
   global staticMvpnVrfStatus4
   global evpnVrfStatus4
   global staticEvpnVrfStatus4
   global vrfIdStatus

   vrfIdStatus = SmashLazyMount.mount( em, 'vrf/vrfIdMapStatus',
                                       'Vrf::VrfIdMap::Status',
                                       SmashLazyMount.mountInfo( 'reader' ),
                                       autoUnmount=True )
   mvpnIntfStatusTypeStr = 'Routing::Multicast::MvpnIntfStatus'
   mvpnIntfStatus4 = SmashLazyMount.mount(
                        em, Tac.Type( mvpnIntfStatusTypeStr ).mountPath(),
                        mvpnIntfStatusTypeStr, SmashLazyMount.mountInfo( 'reader' ) )
   mvpnVrfStatusTypeStr = 'Routing::Multicast::MvpnVrfStatus'
   mvpnVrfStatus4 = SmashLazyMount.mount(
      em, Tac.Type( mvpnVrfStatusTypeStr ).mountPath( 'ipv4', 'bgp' ),
      mvpnVrfStatusTypeStr, SmashLazyMount.mountInfo( 'reader' ) )
   staticMvpnVrfStatus4 = SmashLazyMount.mount(
      em, Tac.Type( mvpnVrfStatusTypeStr ).mountPath( 'ipv4', 'staticMvpn' ),
      mvpnVrfStatusTypeStr, SmashLazyMount.mountInfo( 'reader' ) )
   evpnVrfStatus4 = SmashLazyMount.mount(
      em, Tac.Type( mvpnVrfStatusTypeStr ).mountPath( 'ipv4', 'evpn' ),
      mvpnVrfStatusTypeStr, SmashLazyMount.mountInfo( 'reader' ) )
   staticEvpnVrfStatus4 = SmashLazyMount.mount(
      em, Tac.Type( mvpnVrfStatusTypeStr ).mountPath( 'ipv4', 'staticEvpn' ),
      mvpnVrfStatusTypeStr, SmashLazyMount.mountInfo( 'reader' ) )
