# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.RouterMulticastCliLib as RouterMulticastCliLib
# pylint: disable-next=consider-using-from-import
import CliPlugin.RouteMapCli as RouteMapCli
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from McastCommonCliLib import AddressFamily
import Tac
import Toggles.McastVpnLibToggleLib
import Tracing

traceHandle = Tracing.Handle( "McastVrfLeak" )
t0 = traceHandle.trace0
McastVrfLeakConfig = "Routing::Multicast::VrfLeak::McastVrfLeakConfig"

( mcastVrfLeakConfigRoot,
  mcastVrfLeakConfigRootFromMode,
  mcastVrfLeakConfig,
  mcastVrfLeakConfigFromMode ) = RouterMulticastCliLib.configGetters( 
                                    McastVrfLeakConfig,
                                    collectionName='vrfConfig' )

def configureMcastVrfLeak( mode, args ):
   mvlc = mcastVrfLeakConfigFromMode( mode )
   pfxList = args[ 'PREFIX_LIST' ]
   sourceVrfName = args[ 'TRAFFIC_SOURCE_VRF' ]
   mvlc.sourceVrfGroups[ pfxList ] = sourceVrfName

def unConfigureMcastVrfLeak( mode, args ):
   mvlc = mcastVrfLeakConfigFromMode( mode )
   pfxList = args[ 'PREFIX_LIST' ]
   del mvlc.sourceVrfGroups[ pfxList ] 

class McastVrfLeakConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'leak group prefix-list PREFIX_LIST vrf TRAFFIC_SOURCE_VRF'
   noOrDefaultSyntax = 'leak group prefix-list PREFIX_LIST ...'
   data = {
      'leak': 'Configure VRF leaking policy',
      'group': 'Traffic groups to be leaked',
      'prefix-list': 'Prefix-list specifying the groups to be leaked',
      'PREFIX_LIST' : RouteMapCli.prefixListNameMatcher,
      'vrf' : 'Source VRF for the multicast traffic',
      'TRAFFIC_SOURCE_VRF' : VrfCli.vrfMatcher,
   }

   handler = configureMcastVrfLeak
   noOrDefaultHandler = unConfigureMcastVrfLeak

RouterMulticastCliLib.RouterMulticastIpv4Modelet.addCommandClass(
   McastVrfLeakConfigCmd )
if Toggles.McastVpnLibToggleLib.toggleMcastVrfLeakV6Enabled():
   RouterMulticastCliLib.RouterMulticastIpv6Modelet.addCommandClass(
      McastVrfLeakConfigCmd )

class RouterMcastVrfLeakCleanup( RouterMulticastCliLib.RouterModeCallbackBase ):
   def modeDeleted( self, **kwargs ):
      config = mcastVrfLeakConfigRoot( AddressFamily.ipv4 )
      config.vrfConfig.clear()
      config = mcastVrfLeakConfigRoot( AddressFamily.ipv6 )
      config.vrfConfig.clear()

   def vrfModeDeleted( self, vrfName, **kwargs ):
      config = mcastVrfLeakConfigRoot( AddressFamily.ipv4 )
      del config.vrfConfig[ vrfName ]
      config = mcastVrfLeakConfigRoot( AddressFamily.ipv6 )
      del config.vrfConfig[ vrfName ]

   def afModeDeleted( self, vrfName, af, **kwargs ):
      config = mcastVrfLeakConfigRoot( af )
      del config.vrfConfig[ vrfName ]

def Plugin( entityManager ):
   configTypes = [ McastVrfLeakConfig, ]
   RouterMulticastCliLib.doConfigMounts( entityManager, configTypes )
   RouterMulticastCliLib.RouterMulticastMode.registerCallback(
         RouterMcastVrfLeakCleanup() )
