# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Cell
import LazyMount
import ShowCommand

from CliPlugin import MeasuredBootVersionModel, TpmCliLib
from CliPlugin import ConfigMgmtMode

measuredBootVersion_ = None
unknownVersion = 'n/a'

def showMeasuredBootVersion( mode, args ):
   result = MeasuredBootVersionModel.MeasuredBootVersionList()

   eosVer = measuredBootVersion_.eos if measuredBootVersion_.eos else unknownVersion
   abootVer = \
      measuredBootVersion_.aboot if measuredBootVersion_.aboot else unknownVersion

   result.versions.append( MeasuredBootVersionModel.MeasuredBootVersion(
      name='EOS', version=eosVer ) )
   result.versions.append( MeasuredBootVersionModel.MeasuredBootVersion(
      name='Aboot', version=abootVer ) )

   return result

class ShowMeasuredBootVersionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management security tpm measured-boot version'
   data = {
      'management': ConfigMgmtMode.managementShowKwMatcher,
      'security': 'Show security status',
      'tpm': TpmCliLib.tpmMatcher,
      'measured-boot': 'Show measured boot general info',
      'version': 'Show measured boot version',
   }
   cliModel = MeasuredBootVersionModel.MeasuredBootVersionList
   handler = showMeasuredBootVersion

BasicCli.addShowCommandClass( ShowMeasuredBootVersionCmd )

def Plugin( entityManager ):
   global measuredBootVersion_

   measuredBootVersion_ = LazyMount.mount( entityManager,
      Cell.path( 'platformSecurity/measuredBootVersion' ),
      'PlatformSecurity::MeasuredBootVersion', 'r' )
