# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import ConfigMgmtMode
import ConfigMount
import BasicCliModes
import CliCommand
import CliMatcher
import SecretCli

# ------------------------------
# Defaults config commands
#
# From config mode
#    management default    - enter defaults config mode
#

defaultsConfig = None

class MgmtDefaultsMode( ConfigMgmtMode.ConfigMgmtMode ):
   name = "Management Defaults"

   def __init__( self, parent, session ):
      ConfigMgmtMode.ConfigMgmtMode.__init__( self, parent, session, "defaults" )
      self.config_ = defaultsConfig

   def setSecretHash( self, args ):
      self.config_.hashAlgorithm = args[ 'HASH' ] if 'HASH' in args else 'sha512'

def gotoMgmtDefaultsMode( mode, args ):
   childMode = mode.childMode( MgmtDefaultsMode )
   mode.session_.gotoChildMode( childMode )

def noMgmtDefaultsMode( mode, args ):
   childMode = mode.childMode( MgmtDefaultsMode )
   childMode.removeComment()

#--------------------------------------------------------------------------------
# [ no | default ] management defaults
#--------------------------------------------------------------------------------
class ManagementDefaultsCmd( CliCommand.CliCommandClass ):
   syntax = 'management defaults'
   noOrDefaultSyntax = syntax
   data = {
      'management': ConfigMgmtMode.managementKwMatcher,
      'defaults': 'Configure defaults',
   }
   handler = gotoMgmtDefaultsMode
   noOrDefaultHandler = noMgmtDefaultsMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementDefaultsCmd )

#--------------------------------------------------------------------------------
# [ no | default ] secret hash ( md5 | sha512 | scrypt | yescrypt )
#--------------------------------------------------------------------------------
class SecretHashCmd( CliCommand.CliCommandClass ):
   syntax = 'secret hash HASH'
   noOrDefaultSyntax = 'secret hash ...'
   data = {
         'secret': 'Commands for storing secrets',
         'hash': 'Set default hash algorithm to use',
         'HASH': CliMatcher.EnumMatcher( {
            'md5': 'MD5',
            'sha512': 'SHA-512',
            'scrypt': 'SCRYPT',
            'yescrypt': 'YESCRYPT'
         } )
   }
   handler = MgmtDefaultsMode.setSecretHash
   noOrDefaultHandler = handler

MgmtDefaultsMode.addCommandClass( SecretHashCmd )

def Plugin( entityManager ):
   global defaultsConfig
   defaultsConfig = ConfigMount.mount( entityManager, "mgmt/defaults/config",
                                       "Mgmt::Defaults::Config", "w" )
   SecretCli.setDefaultHashFunc( lambda: defaultsConfig.hashAlgorithm )
