#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.MlagTunnelCli as MlagTunnelCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.MlagConfigCli as MlagConfigCli
from CliPlugin.MlagShowCli import mlagSupportedGuard
from CliToken.Clear import clearKwNode

matcherMlag = CliMatcher.KeywordMatcher( 'mlag', helpdesc='MLAG information' )
nodeMlag = CliCommand.Node( matcher=matcherMlag, guard=mlagSupportedGuard )
nodeLocalInterface = CliCommand.Node(
      matcher=CliMatcher.KeywordMatcher( 'interface',
         helpdesc='Configure actions taken by MLAG on interfaces' ),
      guard=MlagConfigCli.egressFilterInterlockConfigurableGuard )

#--------------------------------------------------------------------------------
# clear mlag tunnel counters
#--------------------------------------------------------------------------------
class ClearMlagTunnelCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear mlag tunnel counters'
   data = {
      'clear': clearKwNode,
      'mlag': nodeMlag,
      'tunnel': 'MLAG tunnel information',
      'counters': 'MLAG tunnel counters',
   }
   handler = MlagTunnelCli.clearMlagTunnelCounters

BasicCliModes.EnableMode.addCommandClass( ClearMlagTunnelCountersCmd )

class ClearMlagInterlockCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear mlag interface interlock filter egress counters'
   data = {
      'clear': clearKwNode,
      'mlag': nodeMlag,
      'interface': nodeLocalInterface,
      'interlock': 'MLAG interface interlock information',
      'filter': 'MLAG filter interlock information',
      'egress': 'MLAG egress filter interlock information',
      'counters': 'MLAG egress filter interlock counters',
   }
   handler = MlagConfigCli.clearMlagInterlockCounters

BasicCliModes.EnableMode.addCommandClass( ClearMlagInterlockCountersCmd )
