#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import
import CliPlugin.TechSupportCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.MlagShowCli as MlagShowCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.MlagConfigCli as MlagConfigCli
from Toggles.MlagToggleLib import toggleMlagL2SubinterfacesEnabled

def mlagShowTechGuard():
   return MlagShowCli.mlagSupportedGuard( mode=None, token=None ) is None

def mlagEgressFilterInterlockGuard():
   return mlagShowTechGuard() and \
          MlagConfigCli.egressFilterInterlockConfigurableGuard( mode=None,
                                                                token=None ) is None

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2011-04-08 21:49:54',
   cmds=[ 'show mlag detail', 'show mlag interfaces detail' ],
   cmdsGuard=mlagShowTechGuard,
   summaryCmds=[ 'show mlag detail' ],
   summaryCmdsGuard=mlagShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2014-11-05 22:05:27',
   cmds=[ 'show mlag config-sanity' ], cmdsGuard=mlagShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2013-10-03 15:20:39',
   cmds=[ 'show mlag tunnel counters' ], cmdsGuard=mlagShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2022-11-17 11:33:39',
   cmds=[ 'show mlag interface interlock filter egress' ],
   cmdsGuard=mlagEgressFilterInterlockGuard )

if toggleMlagL2SubinterfacesEnabled():
   CliPlugin.TechSupportCli.registerShowTechSupportCmd(
      '2023-10-23 11:03:39',
      cmds=[ 'show mlag subinterfaces' ],
      cmdsGuard=mlagShowTechGuard )
