#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliModel import Model, Dict, Int

# Cli Model for "show mlag tunnel..."
class MlagTunnel( Model ):
   rxPkts = Int( help="Received packets" )
   txPkts = Int( help="Transmitted packets" )
   decPkts = Int( help="Decapsulated packets" )
   encPkts = Int( help="Encapsulated packets" )
   class PktTypeCounters( Model ):
      decPkts = Int( help="Decapsulated packets" )
      encPkts = Int( help="Encapsulated packets" )
   pktTypeCounters = Dict( valueType=PktTypeCounters,
                           help="Counters by packet type" )

   def render( self ):
      pairs = ( ( "Received packets", self.rxPkts ),
                ( "Transmitted packets", self.txPkts ),
                ( "Decapsulated packets", self.decPkts ),
                ( "Encapsulated packets", self.encPkts ) )
      for ( label, value ) in pairs:
         # pylint: disable-next=consider-using-f-string
         print( "%s: %s" % ( label, value ) )
      format_ = '%-20s %15s %15s'
      print( format_ % ( 'FrameType', 'DecapPkts' , 'EncapPkts' ) )
      for k in sorted( self.pktTypeCounters ):
         print( format_ % ( k, self.pktTypeCounters[ k ].decPkts, 
                           self.pktTypeCounters[ k ].encPkts ) )
