#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool
from CliModel import Int
from CliModel import List
from CliModel import Model
from CliModel import Str
from IntfModels import Interface

class MonitoredNexthopEntry( Model ):
   ipAddr = Str( help='Nexthop Ip or Ipv6 address' )
   intf = Interface( help='Name of the interface' )

class MonitoredNexthopVrfSummary( Model ):
   vrfname = Str( help='Name of the Vrf' )
   entries = Int( default=0,
                  help="Total number of monitored nexthop entries for the Vrf" )

class MonitoredNexthopCollection( Model ):
   totalEntries = Int( default=0,
                       help="Total number of monitored nexthop entries" )
   entryList = List( valueType=MonitoredNexthopEntry,
                     help="Monitored nexthop entry" )
   _render_summary = Bool( help="Display summary only for show command if True", 
                           default=False )
   vrfList = List( valueType=MonitoredNexthopVrfSummary,
                   help="Monitored nexthop entry count" )
   def render( self ):
      if self._render_summary:
         print( f"Total: {self.totalEntries}" )
         for i in self.vrfList:
            print( f"{i.vrfname:15} {i.entries:8}" )
      else:
         print( 'Address                                  Interface ' )
         for i in self.entryList:
            print( f"{i.ipAddr:39}  {i.intf.stringValue:8}" )
