#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool, Dict, Model
from ArnetModel import IpGenericPrefix
from IntfModels import Interface
import Arnet

# list of prefixes with rpaIndex
class BidirGroup( Model ):
   groups = Dict( keyType=IpGenericPrefix, valueType=int,
                  help='Mapping from prefix to RPA index' )
   bidirEnabled = Bool( help="Pim Bidir enabled", default=True )
   def render( self ):
      if not self.bidirEnabled:
         print( 'Pim Bidir is not enabled' )
         return
      # pylint: disable-next=consider-using-f-string
      print( '%-39s  %8s' % ( 'Prefix', 'Rpa Index' ) )
      for i in sorted( self.groups ):
         # pylint: disable-next=consider-using-f-string
         print( '%-39s  %-8d' % ( i, self.groups[ i ] ) )

class DfProfile( Model ):
   dfProfiles = Dict( keyType=Interface, valueType=int,
                      help='Mapping from interface to DF bitmap' )
   bidirEnabled = Bool( help="Pim Bidir enabled", default=True )
   def render( self ):
      if not self.bidirEnabled:
         print( 'Pim Bidir is not enabled' )
         return
      # pylint: disable-next=consider-using-f-string
      print( '%-10s  %32s' % ( 'Interface', 'DF bitmap' ) )
      for key in Arnet.sortIntf( self.dfProfiles ):
         intfname = str ( key ).replace( '\'', '' )
         tt = self.dfProfiles[ key ]
         ss = ''
         while tt > 0:
            ss = '%d' % ( tt & 1 ) + ss # pylint: disable=consider-using-f-string
            tt = tt // 2
         # pylint: disable-next=consider-using-f-string
         print( '%-10s  %64s (0x%lx)' % ( intfname, ss, self.dfProfiles[ key ] ) )

