# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliToken.Ip
from CliToken.McastCommon import multicastMatcherForShow
import CliToken.Ipv4
import CliToken.Ipv6
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliPlugin import Ip6AddrMatcher
from CliPlugin import IpAddrMatcher
from CliPlugin import MrouteCli
from CliPlugin import MrouteDfModel
import ShowCommand

from McastCommonCliLib import mcastGenRoutingSupportedGuard
from McastCommonCliLib import mcast6RoutingSupportedGuard
from McastCommonCliLib import mcastRoutingSupportedGuard

ipv4Node = CliCommand.Node( matcher=CliToken.Ipv4.ipv4MatcherForShow,
                            guard=mcastRoutingSupportedGuard )
ipv6Node = CliCommand.Node( matcher=CliToken.Ipv6.ipv6MatcherForShow,
                            guard=mcast6RoutingSupportedGuard )
fibKwNode = CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'fib',
                                             helpdesc='Multicast FIB information' ),
                             guard=mcastGenRoutingSupportedGuard )

countersKwMatcher = CliMatcher.KeywordMatcher( 'counters',
                                               helpdesc='Counter for bytes/packets' )
rateKwMatcher = CliMatcher.KeywordMatcher(
      'rate', helpdesc='Counter rate for bytes/packets' )
countKwMatcher = CliMatcher.KeywordMatcher( 'count',
                                            helpdesc='Mroute count information' )
pimModeMatcher = CliMatcher.EnumMatcher( { 'sparse-mode': 'sparse-mode information',
                                       'bidirectional': 'Bidirectional information',
                                       'static': 'Static multicast information',
                                       'mcs' : 'Media Control Service information',
                                       } )
summaryKwMatcher = CliMatcher.KeywordMatcher( 'summary',
                                              helpdesc='Multicast FIB summary' )
rpaKwMatcher = CliMatcher.KeywordMatcher( 'rpa', helpdesc='Pim Bidir RPA index' )

mfibKwMatcher = CliMatcher.KeywordMatcher( 'mfib', helpdesc='Multicast FIB' )
mfibKwDeprecatedNode = CliCommand.Node( matcher=mfibKwMatcher,
                                        guard=mcastRoutingSupportedGuard,
                                        deprecatedByCmd='show multicast fib ipv4' )
vrfExprFactory = VrfCli.VrfExprFactory( helpdesc='VRF name' )
prefixMatcher = IpAddrMatcher.IpPrefixMatcher( helpdesc='IP prefix address' )
groupIpv4AddrMatcher = IpAddrMatcher.IpAddrMatcher( helpdesc='Group address' )
srcIpv4AddrMatcher = IpAddrMatcher.IpAddrMatcher( helpdesc='Source address' )
groupIpv6AddrMatcher = Ip6AddrMatcher.Ip6AddrMatcher( helpdesc='Group address' )
srcIpv6AddrMatcher = Ip6AddrMatcher.Ip6AddrMatcher( helpdesc='Source address' )
dfKwMatcher = CliMatcher.KeywordMatcher( 'df',
                                         helpdesc='PIM bidirectional DF bitmap' )

#-----------------------------------------------------------------------------------
# show ip mfib [ VRF ] [ GROUP [ SOURCE ] ] [ counters ]
#-----------------------------------------------------------------------------------
class DeprecatedShowIpv4Mfib( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib [ VRF ] [ GROUP [ SOURCE ] ] [ counters ]'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'counters': countersKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfib

BasicCli.addShowCommandClass( DeprecatedShowIpv4Mfib )

#-----------------------------------------------------------------------------------
# show ip mfib PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] [ counters ]
#-----------------------------------------------------------------------------------
class DeprecatedShowIpMfibByPimMode( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] [ counters ]'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'counters': countersKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfibByPimMode

BasicCli.addShowCommandClass( DeprecatedShowIpMfibByPimMode )

#-----------------------------------------------------------------------------------
# show ip mfib [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class DeprecatedShowIpMfibCount( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib [ VRF ] [ GROUP [ SOURCE ] ] count'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibCount

BasicCli.addShowCommandClass( DeprecatedShowIpMfibCount )

#-----------------------------------------------------------------------------------
# show ip mfib PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class DeprecatedShowIpMfibByPimModeCount( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] count'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'SOURCE': srcIpv4AddrMatcher,
            'GROUP': groupIpv4AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibByPimModeCount

BasicCli.addShowCommandClass( DeprecatedShowIpMfibByPimModeCount )

#-----------------------------------------------------------------------------------
# show ip mfib [ VRF ] rpa [ PREFIX ]
#-----------------------------------------------------------------------------------
class DeprecatedShowIpMfibRpa( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib [ VRF ] rpa [ PREFIX ]'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'VRF': vrfExprFactory,
            'rpa': rpaKwMatcher,
            'PREFIX': prefixMatcher
          }
   cliModel = MrouteDfModel.BidirGroup
   handler =  MrouteCli.showIpMfibBidirRpa

BasicCli.addShowCommandClass( DeprecatedShowIpMfibRpa )

#-----------------------------------------------------------------------------------
# show ip mfib [ VRF ] summary
#-----------------------------------------------------------------------------------
class DeprecatedShowIpMfibSummary( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip mfib [ VRF ] summary'
   data = { 
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'VRF': vrfExprFactory,
            'summary': summaryKwMatcher,
          }
   handler = MrouteCli.showIpMfibSummary

BasicCli.addShowCommandClass( DeprecatedShowIpMfibSummary )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 [ VRF ] [ GROUP [ SOURCE ] ] [ counters [ rate ] ]
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv4 '
              '[ VRF ] [ GROUP [ SOURCE ] ] [ counters [ rate ] ]' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'VRF': vrfExprFactory,
            'SOURCE': srcIpv4AddrMatcher,
            'GROUP': groupIpv4AddrMatcher,
            'counters': countersKwMatcher,
            'rate': rateKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfib

BasicCli.addShowCommandClass( ShowMulticastFibIpv4 )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] [ counters ] [ rate ]
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4ByPimMode( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv4 PIM_MODE '
              '[ VRF ] [ GROUP [ SOURCE ] ] [ counters ] [ rate ]' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'counters': countersKwMatcher,
            'rate': rateKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfibByPimMode

BasicCli.addShowCommandClass( ShowMulticastFibIpv4ByPimMode )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4CountByPimMode( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv4 PIM_MODE '
              '[ VRF ] [ GROUP [ SOURCE ] ] count' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibByPimModeCount

BasicCli.addShowCommandClass( ShowMulticastFibIpv4CountByPimMode )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4Count( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast fib ipv4 [ VRF ] [ GROUP [ SOURCE ] ] count'
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv4AddrMatcher,
            'SOURCE': srcIpv4AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibCount

BasicCli.addShowCommandClass( ShowMulticastFibIpv4Count )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 [ VRF ] rpa [ PREFIX ]
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4Rpa( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast fib ipv4 [ VRF ] rpa [ PREFIX ]'
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'VRF': vrfExprFactory,
            'rpa': rpaKwMatcher,
            'PREFIX': prefixMatcher
          }
   cliModel = MrouteDfModel.BidirGroup
   handler =  MrouteCli.showIpMfibBidirRpa

BasicCli.addShowCommandClass( ShowMulticastFibIpv4Rpa )

#-----------------------------------------------------------------------------------
# show multicast fib ipv4 [ VRF ] summary
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv4Summary( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast fib ipv4 [ VRF ] summary'
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'VRF': vrfExprFactory,
            'summary': summaryKwMatcher,
          }
   handler = MrouteCli.showIpMfibSummary

BasicCli.addShowCommandClass( ShowMulticastFibIpv4Summary )

#-----------------------------------------------------------------------------------
# show multicast fib ipv6 [ VRF ] [ GROUP [ SOURCE ] ]  [ counters [ rate ] ]
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv6( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv6 '
              '[ VRF ] [ GROUP [ SOURCE ] ] [ counters [ rate ] ]' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv6': ipv6Node,
            'VRF': vrfExprFactory,
            'SOURCE': srcIpv6AddrMatcher,
            'GROUP': groupIpv6AddrMatcher,
            'counters': countersKwMatcher,
            'rate': rateKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfib

BasicCli.addShowCommandClass( ShowMulticastFibIpv6 )

#-----------------------------------------------------------------------------------
# show multicast fib ipv6 PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] [ counters ]
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv6ByPimMode( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv6 PIM_MODE '
              '[ VRF ] [ GROUP [ SOURCE ] ] [ counters ]' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv6': ipv6Node,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv6AddrMatcher,
            'SOURCE': srcIpv6AddrMatcher,
            'counters': countersKwMatcher,
          }
   cliModel = "McastCommonModel.MfibGroups"
   handler = MrouteCli.showIpMfibByPimMode

BasicCli.addShowCommandClass( ShowMulticastFibIpv6ByPimMode )

#-----------------------------------------------------------------------------------
# show multicast fib ipv6 [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv6Count( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast fib ipv6 [ VRF ] [ GROUP [ SOURCE ] ] count'
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv6': ipv6Node,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv6AddrMatcher,
            'SOURCE': srcIpv6AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibCount

BasicCli.addShowCommandClass( ShowMulticastFibIpv6Count )

#-----------------------------------------------------------------------------------
# show multicast fib ipv6 PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] count
#-----------------------------------------------------------------------------------
class ShowMulticastFibIpv6CountByPimMode( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv6 PIM_MODE [ VRF ] [ GROUP [ SOURCE ] ] '
              'count' )
   data = { 
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv6': ipv6Node,
            'PIM_MODE': pimModeMatcher,
            'VRF': vrfExprFactory,
            'GROUP': groupIpv6AddrMatcher,
            'SOURCE': srcIpv6AddrMatcher,
            'count': countKwMatcher,
          }
   handler = MrouteCli.showIpMfibByPimModeCount

BasicCli.addShowCommandClass( ShowMulticastFibIpv6CountByPimMode )

class DeprecatedShowMulticastFibBidirDf( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show ip mfib [ VRF ] df [ INTF ]' )
   data = {
            'ip': CliToken.Ip.ipMatcherForShow,
            'mfib': mfibKwDeprecatedNode,
            'VRF': vrfExprFactory,
            'df': dfKwMatcher,
            'INTF': MrouteCli.intfMatcher
          }
   handler = MrouteCli.showIpMfibBidirDf
   cliModel = MrouteDfModel.DfProfile

BasicCli.addShowCommandClass( DeprecatedShowMulticastFibBidirDf )

class ShowMulticastFibBidirDf( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show multicast fib ipv4 [ VRF ] df [ INTF ]' )
   data = {
            'multicast': multicastMatcherForShow,
            'fib': fibKwNode,
            'ipv4': ipv4Node,
            'VRF': vrfExprFactory,
            'df': dfKwMatcher,
            'INTF': MrouteCli.intfMatcher
          }
   handler = MrouteCli.showIpMfibBidirDf
   cliModel = MrouteDfModel.DfProfile

BasicCli.addShowCommandClass( ShowMulticastFibBidirDf )

