# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher
from Ethernet import quad

# pylint: disable-next=consider-using-f-string
streamPattern = r'%s(\.%s)?(\.%s)?(\.%s)?$' % ( quad, quad, quad, quad )
matcherStreamPattern = CliMatcher.PatternMatcher( streamPattern,
      helpname='H.H.H.H', helpdesc='Stream identifier' )

def convertStreamIdToHexString( streamId ):
   '''Converts a stream identifier from an integer representation to the
   format in which stream identifiers are displayed in the output of 'show'
   commands.'''
   # XXX There has to be a better way than I am doing this
   streamIdHex = '%016x' % streamId # pylint: disable=consider-using-f-string
   quads = ( streamIdHex[ i:i + 4 ] for i in range( 0, 16, 4 ) )
   return '.'.join( quads )

def matchStreamId( mask, possibleStreamId, registeredStreamId ):
   '''Matches input stream id with registered stream id '''
   for i in range( len( mask ) ): # pylint: disable=consider-using-enumerate
      if ( registeredStreamId & mask[ i ] ) == possibleStreamId[ i ]:
         return True
   return False

def maskForStreamId( length, sId ):
   '''Returns a suitable mask based on length of stream identifier and
   possible representation for stream identifier '''
   if length == 12:
      mask = [ 0xffffffffffff0000, 0x0000ffffffffffff ]
      possibleStreamId = [ sId << 16, sId ]
   elif length == 8:
      mask = [ 0x0000ffffffff0000, 0xffffffff00000000, 0x00000000ffffffff ]
      possibleStreamId = [ sId << 16, sId << 32, sId ] 
   elif length == 4:
      mask = [ 0x000000000000ffff, 0x00000000ffff0000, 0x0000ffff00000000,
               0xffff000000000000 ]
      possibleStreamId = [ sId , sId << 16, sId << 32, sId << 48 ]
   else:
      mask = [ 0xffffffffffffffff ]
      possibleStreamId = [ sId ]
   return ( mask, possibleStreamId )

def convertStreamIdDisplayToInt( streamId ):
   '''Converts a stream identifier from the string display representation to the
   integer format. Also return the length of original stream identifier
   after removing dots'''
   streamId = streamId.replace( '.', '' )
   return ( int( streamId, 16 ), len( streamId ) )
