#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from CliModel import Dict, Model, Submodel

class EvpnVlanVniCheck( Model ):
   vlans = Dict(
       keyType=int,
       valueType=int, help="Mapping of VLAN to VNI",
       optional=True, valueOptional=True )

   def render( self ):
      for vlan in self.vlans:
         print( f"VLAN {vlan} to VNI mapping does not exist" )

class VrfCheck( Model ):
   vrfs = Dict(
       valueType=int, help="Mapping of VRF to VNI",
       optional=True, valueOptional=True )

   def render( self ):
      for vrf in self.vrfs:
         print( f"VRF {vrf} has no VNI config" )

class McastVpnVlanConfigCheck( Model ):
   evpnVlanVniSet = Submodel(
       help="VLANs missing VXLAN VNI configuration",
       valueType=EvpnVlanVniCheck, optional=True )
   vrfSet = Submodel(
       help="VRFs missing VXLAN VNI configuration",
       valueType=VrfCheck, optional=True )

   def render( self ):
      if self.evpnVlanVniSet:
         self.evpnVlanVniSet.render()
      if self.vrfSet:
         self.vrfSet.render()
