#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
from CliMatcher import EnumMatcher
from CliToken.Ip import ipMatcherForConfig
import CliPlugin.NatCli as NatCli # pylint: disable=consider-using-from-import
from CliPlugin.NatCli import (
      nodeNat,
      nodeServiceList,
      matcherServiceListName,
)

#--------------------------------------------------------------------------------
# [ no | default ] ip nat service-list SERVICELISTNAME
#--------------------------------------------------------------------------------
class IpNatServiceListCmd( CliCommand.CliCommandClass ):
   syntax = 'ip nat service-list NAME'
   noOrDefaultSyntax = syntax
   data = {
      'ip' : ipMatcherForConfig,
      'nat' : nodeNat,
      'service-list' : nodeServiceList,
      'NAME' : matcherServiceListName,
   }

   handler = NatCli.gotoIpNatServiceListConfigMode
   noOrDefaultHandler = NatCli.deleteIpNatServiceListMode

BasicCliModes.GlobalConfigMode.addCommandClass( IpNatServiceListCmd )

#--------------------------------------------------------------------------------
# [ no | default ] service SERVICETYPE
#--------------------------------------------------------------------------------
# ftp is the only service type supported for now
class IpNatServiceTypeCmd( CliCommand.CliCommandClass ):
   syntax = 'service SERVICETYPE'
   noOrDefaultSyntax = syntax
   data = {
      'service' : 'Enable ALG for service',
      # pylint: disable-next=consider-using-f-string
      'SERVICETYPE' : EnumMatcher( { proto : "Nat %s ALG" % proto for proto
                                     in NatCli.NatServiceListService.protos } ),
   }

   handler = NatCli.NatServiceListConfigMode.addService
   noOrDefaultHandler = NatCli.NatServiceListConfigMode.noService

NatCli.NatServiceListConfigMode.addCommandClass( IpNatServiceTypeCmd )
