# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
from CliCommand import Node, CliCommandClass
from CliMatcher import IntegerMatcher

from CliPlugin.IraVrfCli import VrfDefinitionMode
import CliPlugin.NatCli as NatCli # pylint: disable=consider-using-from-import
from CliPlugin.NatCli import (
      matcherNat,
      matcherSource,
      matcherTarget,
      matcherStatic,
      matcherIpLocal,
      matcherIpGlobal,
      nodeNat,
      natVrfHopStaticSupported,
      natOutsideVrfSupported,
)
from CliPlugin.VrfCli import VrfExprFactory
from CliToken.Ip import ipMatcherForConfig

nodeNatVrfHop = Node(
      matcher=matcherNat,
      guard=natOutsideVrfSupported )
insideVrfExprFactory = VrfExprFactory(
      keyword='inside-vrf',
      helpdesc='Inside VRF' )

for ( mode, natNode ) in (
      ( BasicCliModes.GlobalConfigMode, nodeNat ),
      ( VrfDefinitionMode, nodeNatVrfHop ) ):
   #--------------------------------------------------------------------------------
   # [ no | default ] ip nat source inside-vrf VRF rate RATE burst BURST
   #--------------------------------------------------------------------------------
   class IpNatStaticVrfHopPolicerCmd( CliCommandClass ):
      syntax = 'ip nat source INSIDE_VRF rate RATE burst BURST'
      noOrDefaultSyntax = 'ip nat source INSIDE_VRF rate ...'
      data = {
         'ip' : ipMatcherForConfig,
         'nat' : natNode,
         'source' : Node( matcher=matcherSource, guard=natVrfHopStaticSupported ),
         'INSIDE_VRF' : insideVrfExprFactory,
         'rate' : 'Set rate',
         'RATE' : IntegerMatcher( 1000, 1000000000, helpdesc='Rate (kbits)' ),
         'burst' : 'Set burst-size',
         'BURST' : IntegerMatcher( 1000, 1000000, helpdesc='Burst (bytes)' ),
      }

      handler = NatCli.cmdStaticNatVrfPolicer
      noOrDefaultHandler = NatCli.cmdNoStaticNatVrfPolicer

   mode.addCommandClass( IpNatStaticVrfHopPolicerCmd )

   #--------------------------------------------------------------------------------
   # [ no | default ] ip nat TARGET static LOCALIP GLOBALIP inside-vrf VRF
   #--------------------------------------------------------------------------------
   class IpNatStaticVrfHopCmd( CliCommandClass ):
      syntax = 'ip nat TARGET static LOCALIP GLOBALIP INSIDE_VRF'
      noOrDefaultSyntax = syntax
      data = {
         'ip' : ipMatcherForConfig,
         'nat' : natNode,
         'TARGET' : Node( matcher=matcherTarget, guard=natVrfHopStaticSupported ),
         'static' : matcherStatic,
         'LOCALIP' : matcherIpLocal,
         'GLOBALIP' : matcherIpGlobal,
         'INSIDE_VRF' : insideVrfExprFactory,
      }

      handler = NatCli.cmdStaticNatVrf
      noOrDefaultHandler = NatCli.cmdNoStaticNatVrf

   mode.addCommandClass( IpNatStaticVrfHopCmd )

