# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin import NorCalCardShowCommands
from CliToken.Hardware import hardwareMatcherForConfig

#--------------------------------------------------------------------------------
# hardware fabric ejector-handle open action [ power-off | log ]
# ( no | default ) hardware fabric ejector-handle open action ...
#--------------------------------------------------------------------------------
class HardwareFabricEjectorHandleOpenActionCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware fabric ejector-handle open action VALUE'
   noOrDefaultSyntax = 'hardware fabric ejector-handle open action ...'
   data = {
      'hardware' : hardwareMatcherForConfig,
      'fabric' : 'Fabric card configuration',
      'ejector-handle' : CliCommand.guardedKeyword(
          'ejector-handle',
          helpdesc='Ejector handle configuration',
          guard=NorCalCardShowCommands.ejectorHandleGuard ),
      'open' : 'Configure behavior when ejector handles are open',
      'action' : 'Action taken when ejector handles are open',
      'VALUE' : CliMatcher.EnumMatcher( {
         'power-off' : 'Power-off fabric cards',
         'log' : 'Keep fabric cards powered and output log warning',
       } ),
   }

   handler = "NorCalCardCliHandler.doHardwareEjectorHandle"
   noOrDefaultHandler = "NorCalCardCliHandler.doHardwareEjectorHandlePowerOff"

BasicCliModes.GlobalConfigMode.addCommandClass(
   HardwareFabricEjectorHandleOpenActionCmd )
