#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.AclCli as AclCli # pylint: disable=consider-using-from-import
import CliPlugin.Ntp as Ntp # pylint: disable=consider-using-from-import
import CliToken.Clear

#--------------------------------------------------------------------------------
# clear ntp ip access-list counters
#--------------------------------------------------------------------------------
class ClearNtpIpAccessListCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ntp ( ip | ipv6 ) access-list counters'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'ntp': 'NTP',
      'ip': AclCli.ipKwForClearServiceAclMatcher,
      'ipv6': AclCli.ipv6KwMatcherForClearServiceAcl,
      'access-list': AclCli.accessListKwMatcherForServiceAcl,
      'counters': AclCli.countersKwMatcher
   }
   handler = Ntp.clearNtpIpAclCounters

BasicCliModes.EnableMode.addCommandClass( ClearNtpIpAccessListCountersCmd )
