# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AclCliLib
import AgentDirectory
import ConfigMount
import LazyMount
import Tac
from socket import IPPROTO_TCP

# pkgdeps: rpmwith %{_libdir}/preinit/Security

aclConfig = None
aclCpConfig = None
sslConfig = None
sslServiceStatus = None
em = None


def isAgentRunning():
   return bool( AgentDirectory.agent( em.sysname(), 'OpenConfig' ) or \
      AgentDirectory.agent( em.sysname(), 'Octa' ) )

def updateLevelEnabledFlag( config ):
   serverEnabled = any( endpoint.enabled for endpoint in config.endpoints.values() )
   grpctunnelClients = getattr( config, "grpctunnelClients", {} ) # for gNMI only
   grpctunnelEnabled = any( client.enabled for client in grpctunnelClients.values() )
   config.enabled = serverEnabled or grpctunnelEnabled

def otherEnabledTransportExists( mode, name ):
   for e in mode.config_.endpoints.values():
      if e.enabled and e.name != name:
         mode.addError( "transport '%s' of type '%s' is already enabled; "
                        "can not create another" % ( e.name, e.transport ) )
         return True

   return False

def createSslServiceStatusEntity( serviceStatusName ):
   if serviceStatusName not in sslServiceStatus:
      sslServiceStatus.newEntity( "Mgmt::Security::Ssl::ServiceStatus",
                                  serviceStatusName )

def deleteSslServiceStatusEntity( serviceStatusName ):
   if serviceStatusName in sslServiceStatus:
      sslServiceStatus.deleteEntity( serviceStatusName )

def noServiceAcl( mode, service, endpoint, aclType="ip" ):
   AclCliLib.noServiceAcl( mode, service, aclConfig, aclCpConfig,
         None, aclType, endpoint.vrfName )

def setServiceAcl( mode, service, endpoint, aclType="ip" ):
   AclCliLib.setServiceAcl( mode, service, IPPROTO_TCP, aclConfig, aclCpConfig,
         endpoint.serviceAcl, aclType, endpoint.vrfName, port=[ endpoint.port ] )

def existsOtherTransportSameVrfWithServiceAcl( mode, vrfName ):
   for endpoint in mode.config_.endpoints.values():
      if vrfName == endpoint.vrfName and endpoint.serviceAcl:
         mode.addError( "transport '%s' in VRF %s already configured with "
                        "service ACL '%s'; only one transport in the same VRF "
                        "can be configured with a service ACL; all transports "
                        "in the same VRF use the same service ACL" %
                        ( endpoint.name, endpoint.vrfName, endpoint.serviceAcl ) )
         return True
   return False

def Plugin( entityManager ):
   global sslConfig, sslServiceStatus, em
   global aclConfig, aclCpConfig
   em = entityManager

   aclConfig = ConfigMount.mount( entityManager,
                                  "acl/config/cli",
                                  "Acl::Input::Config",
                                  "w" )
   aclCpConfig = ConfigMount.mount( entityManager,
                                    "acl/cpconfig/cli",
                                    "Acl::Input::CpConfig",
                                    "w" )
   sslConfig = LazyMount.mount( entityManager,
                                "mgmt/security/ssl/config",
                                "Mgmt::Security::Ssl::Config",
                                "r" )
   sslServiceStatus = LazyMount.mount( entityManager,
                                       "mgmt/security/ssl/serviceStatus",
                                       "Tac::Dir",
                                       "w" )
