#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliPlugin import RestconfCli
import CliToken.OpenConfigTokens
from CliMatcher import StringMatcher

#--------------------------------------------------------------------------------
# [ no | default ] transport https TRANSPORT_NAME
#--------------------------------------------------------------------------------
class TransportHttpsCmd( CliCommand.CliCommandClass ):
   syntax = 'transport https TRANSPORT_NAME'
   noOrDefaultSyntax = syntax
   data = {
      'transport': CliToken.OpenConfigTokens.matcherTransport,
      'https': 'Configure https transport for RESTCONF',
      'TRANSPORT_NAME': StringMatcher( helpdesc='Transport name', helpname='WORD' ),
   }
   handler = RestconfCli.gotoRestconfTransportConfigMode
   noOrDefaultHandler = RestconfCli.noRestconfTransportConfigMode

RestconfCli.MgmtRestconfConfigMode.addCommandClass( TransportHttpsCmd )
