#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import CliToken.OpenConfigTokens
from CliPlugin import NetconfCli
from CliPlugin import VrfCli

#--------------------------------------------------------------------------------
#  vrf VRFNAME 
#--------------------------------------------------------------------------------
class Cmd( CliCommand.CliCommandClass ):
   syntax = 'vrf VRFNAME'
   noOrDefaultSyntax = 'vrf ...'
   data = {
      'vrf': 'Configure VRF',
      'VRFNAME': CliMatcher.DynamicNameMatcher( VrfCli.getVrfNames, 'VRF name' ),
   }
   handler = NetconfCli.setVrfName
   noOrDefaultHandler = handler

NetconfCli.NetconfTransportConfigMode.addCommandClass( Cmd )

#--------------------------------------------------------------------------------
# [ no | default ] port PORT
#--------------------------------------------------------------------------------
class PortCmd( CliCommand.CliCommandClass ):
   syntax = 'port PORT'
   noOrDefaultSyntax = 'port ...'
   data = {
      'port': 'The port number to listen on',
      'PORT': CliToken.OpenConfigTokens.matcherPortValue,
   }
   handler = NetconfCli.setPort
   noOrDefaultHandler = handler

NetconfCli.NetconfTransportConfigMode.addCommandClass( PortCmd )

#--------------------------------------------------------------------------------
# [ no | default ] shutdown
#--------------------------------------------------------------------------------
class ShutdownCmd( CliCommand.CliCommandClass ):
   syntax = 'shutdown'
   noOrDefaultSyntax = syntax
   data = {
      'shutdown': 'Disable protocol',
   }
   handler = NetconfCli.shutdown
   noHandler = NetconfCli.noShutdown
   defaultHandler = NetconfCli.shutdown

NetconfCli.NetconfTransportConfigMode.addCommandClass( ShutdownCmd )

