#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.OpenFlowCli as OpenFlowCli

#--------------------------------------------------------------------------------
# [ no | default ] openflow
#--------------------------------------------------------------------------------
class OpenflowCmd( CliCommand.CliCommandClass ):
   syntax = 'openflow'
   noOrDefaultSyntax = syntax
   data = {
      'openflow': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'openflow',
            helpdesc='OpenFlow configuration' ),
         guard=OpenFlowCli.openFlowSupportedGuard ),
   }
   handler = lambda mode, args: OpenFlowCli.gotoOpenFlowConfigMode( mode )
   noOrDefaultHandler = lambda mode, args: OpenFlowCli.clearOpenFlowConfig( mode )

BasicCliModes.GlobalConfigMode.addCommandClass( OpenflowCmd )
