# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import TechSupportCli
from AgentDirectory import agentIsRunning

sysname = None

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2021-11-05 16:56:46',
   cmds=[ 'show p4-runtime',
          'show p4-runtime device',
          'show p4-runtime device counters packet-io' ],
   cmdsGuard=lambda: agentIsRunning( sysname, 'P4Runtime' ) )

def Plugin( entityManager ):
   global sysname
   sysname = entityManager.sysname()
