# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
import LazyMount
import Cell


phyFeatureStatusSliceDir = None
ethPhyIntfDescSliceDir = None

def checkPhyFeatureStatusDirGeneration( phyFeatureStatusSubSliceDirName,
                                        phyFeatureStatusDir ):
   # Get the right ethPhyIntfDesDirName
   ethPhyIntfDescDirName = phyFeatureStatusSubSliceDirName
   if phyFeatureStatusSubSliceDirName == "FixedSystem":
      ethPhyIntfDescDirName = str( Cell.cellId() )
   # Get a pointer to the ethPhyIntfDescDir.
   ethPhyIntfDescDir = ethPhyIntfDescSliceDir.get( ethPhyIntfDescDirName )
   # Check for generation match.
   return ( ethPhyIntfDescDir and ( phyFeatureStatusDir.generation.valid and
               ( phyFeatureStatusDir.generation == ethPhyIntfDescDir.generation ) ) )

def getTxClockShift( phyFeatureStatusSubSliceDir, intfId ):
   # Check to see if any one of the subSliceDirs have an entry for this
   # interface.
   # For now we will be returning the first subSlice that has a valid generationId
   # and a non-zero txClockShift.
   defaultTxClockShift = \
         Tac.Type( "Hardware::Phy::PhyFeatureConfig" ).defaultTxClockShift
   if phyFeatureStatusSubSliceDir:
      for phyFeatureStatusDir in phyFeatureStatusSubSliceDir.values():
         if checkPhyFeatureStatusDirGeneration( phyFeatureStatusSubSliceDir.name,
                                                phyFeatureStatusDir ):
            phyFeatureStatus = phyFeatureStatusDir.status.get( intfId )
            # Return the first subSliceDir that has a non-zero
            # txClockShift value for now.
            if ( phyFeatureStatus and
                    phyFeatureStatus.txClockShift != defaultTxClockShift ):
               return phyFeatureStatus.txClockShift
   return defaultTxClockShift

def getPhyFeatureStatusNested( intfId ):
   if not phyFeatureStatusSliceDir:
      return None

   for linecard in phyFeatureStatusSliceDir.values():
      for subSlice in linecard.values():
         if intfId in subSlice.status:
            return subSlice.status[ intfId ]
   return None

# Helper to get the phyFeatureSupported attr.
def isPhyFeatureSupportedNested( intfId, phyFeatureSupported ):
   phyFeatureStatus = getPhyFeatureStatusNested( intfId )
   return phyFeatureStatus and getattr( phyFeatureStatus, phyFeatureSupported )

def Plugin( em ):
   global phyFeatureStatusSliceDir
   global ethPhyIntfDescSliceDir

   phyFeatureStatusSliceDir = LazyMount.mount(
            em, 'hardware/archer/phy/status/feature/slice', 'Tac::Dir', 'ri' )

   ethPhyIntfDescSliceDir = LazyMount.mount(
            em, 'interface/archer/status/init/eth/phy/slice', 'Tac::Dir', 'ri' )
