# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin import IntfCli
from CliPlugin import PhyNegotiationModel
import ProductAttributes

# A collection of CLI models that support `render` function, which prints the PD
# states of the `show int nego detail` command. Each CLI model is indexed by a
# phyStatusTypeStr.
autonegStatesModelsCol: dict[ str, PhyNegotiationModel.AutonegStatesBase ] = {}

def registerAutonegStatesModel( phyStatusTypeStr, cliModelClass ):
   assert phyStatusTypeStr not in autonegStatesModelsCol
   autonegStatesModelsCol[ phyStatusTypeStr ] = cliModelClass

# A collection of CLI models that support `render` function, which prints the
# per-lane PD training data part of the `show int nego detail` command. Each
# CLI model is indexed by a phyStatusTypeStr.
autonegTrainingModelsCol: dict[ str, PhyNegotiationModel.TrainingBase ] = {}

def registerAutonegTrainingModel( phyStatusTypeStr, cliModelClass ):
   assert phyStatusTypeStr not in autonegTrainingModelsCol
   autonegTrainingModelsCol[ phyStatusTypeStr ] = cliModelClass

# ------------------------------------------------------------------------------
# The "show interfaces [<name>] negotiation detail" command, in enable mode.
#   show interfaces [<name>] negotiation detail
#   show interfaces module <modnum> negotiation detail
# ------------------------------------------------------------------------------
class ShowIntfNegotiationDetailLegacy( IntfCli.ShowIntfCommand ):
   syntax = 'show interfaces negotiation detail'
   data = dict( negotiation='Show interface Auto-Negotiation status',
                detail='Show detailed interface Auto-Negotiation status' )
   allowAllSyntax = True
   handler = "PhyNegotiationCliHandler.showInterfacesNegotiationDetailLegacy"

class ShowIntfNegotiationDetail( IntfCli.ShowIntfCommand ):
   syntax = 'show interfaces negotiation detail'
   data = {
         'negotiation': 'Show interface Auto-Negotiation status',
         'detail': 'Show detailed interface Auto-Negotiation status'
      }
   allowAllSyntax = True
   handler = "PhyNegotiationCliHandler.showInterfacesNegotiationDetail"
   cliModel = PhyNegotiationModel.NegotiationStatusesDetailed

pa = ProductAttributes.productAttributes().productAttributes
if pa.showVerboseNegotiationDetail:
   BasicCli.addShowCommandClass( ShowIntfNegotiationDetail )
else:
   BasicCli.addShowCommandClass( ShowIntfNegotiationDetailLegacy )

def Plugin( entityManager ):
   pass
