# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
from CliPlugin.PhyTxEqShowCmd import laneRangeMatcher
import ShowCommand
from Toggles.L1TopologyToggleLib import toggleXcvrPolarityShowCommandEnabled

# -----------------------------------------------------------------------------
# show phy polarity [ slot SLOT [ lanes LANES ] ]
#
# Displays the current polarity configurations.
# -----------------------------------------------------------------------------
class ShowPhyPolaritySettings( ShowCommand.ShowCliCommandClass ):
   syntax = 'show phy polarity [ slot SLOT [ lanes LANES ] ]'
   data = {
      'phy': 'Show PHY-specific information',
      'polarity': 'Polarity information',
      'slot': 'Specify which slot the polarity should be shown on',
      'SLOT': CliMatcher.PatternMatcher( pattern=r'\w+\d+(/\d+)?',
                                         helpdesc='Slot name',
                                         helpname='SLOT' ),
      'lanes': 'Specify which lanes the polarity should be shown on',
      'LANES': laneRangeMatcher
   }
   cliModel = "PhyPolarityModel.PhyPolaritySettings"
   handler = "PhyPolarityHandler.showPhyPolarityHandler"

if toggleXcvrPolarityShowCommandEnabled():
   BasicCli.addShowCommandClass( ShowPhyPolaritySettings )
