# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel
from CliPlugin import PhyStatusModel

linktrnStsToStr = { 0 : 'init',
                    1 : 'in-training',
                    2 : 'train-local',
                    3 : 'train-remote',
                    4 : 'link-ready',
                    5 : 'complete',
                    6 : 'failed',
                    7 : 'invalid' }

rxPamModeToStr = { 0 : 'NRZ',
                   1 : 'PAM4_NS',
                   2 : 'PAM4_ES' }

brPdEnToStr = { 0 : 'OS',
                1 : 'BR' }

txPiEnToStr = { 0 : 'Disabled',
                1 : 'Enabled' }

#BUG286621 : To track the private attributes
class SerdesLaneStatus( CliModel.Model ):
   """Common information of one serdes lane in an internal PHY."""
   rxPpm = CliModel.Int( optional=True,
                         help="Frequency offset of local reference clock with "
                         "respect to the frequency of received data in ppm" )
   _clk90 = CliModel.Int( optional=True, help="Delay of zero crossing m1 slicer" )
   vga = CliModel.Int( optional=True, help="Variable gain amplifier value" )
   _dcOffset = CliModel.Int( optional=True, help="DC offset" )
   txPpm = CliModel.Int( optional=True,
                         help="Frequency offset of local reference clock with "
                         "respect to the transmit data in ppm" )
   dfeTaps = CliModel.Dict( keyType=int, valueType=int, optional=True,
                            help="Serdes lane Decision Feedback Equalizer"
                            " ( DFE ) taps" )
   txTaps = CliModel.Dict( keyType=int, valueType=int, optional=True,
                           help="Serdes lane TX pre-emphasis taps" )
   _laneId = CliModel.Int( help="Logical lane Id" )

   def toModel( self, serdes ):
      self._laneId = serdes.serdesId.laneId
      for attr in ( 'rxPpm', '_clk90', 'vga', '_dcOffset', 'txPpm' ):
         setattr( self, attr, getattr( serdes, attr.lstrip('_') ) )
      for attr in ( 'dfeTaps', 'txTaps' ):
         setattr( self, attr, dict( getattr( serdes, attr ) ) )
      return self

def printLinkTrainingInfo( laneId, enabled, status ):
   laneStr = f'  Lane {laneId}'
   if enabled:
      print( PhyStatusModel.phyDetailInfoFmt % ( laneStr,  status ) )
   else:
      print( PhyStatusModel.phyDetailInfoFmt % ( laneStr, 'off' ) )
