# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

from CliPlugin.PhySerdesModelCommon import SerdesLaneStatus

class D5PhySerdesLaneModel( SerdesLaneStatus ):
   # these three are cint script use only
   dlevOdd = CliModel.Int( "Arista internal" )
   dlevEven = CliModel.Int( "Arista internal" )
   passEq = CliModel.Int( "Arista internal" )

   aeq = CliModel.Int( "High peaking filter" )

   # H2-9
   # H2 is 7 bits
   # H3,4 are 6 bits
   # H5 is 5 bits
   # H6-9 are 4 bits
   # These will be in the DFE taps above
   # The H1P and H1N taps are special
   # H1P_0 10 bits
   h1p0 = CliModel.Int( "DFE Tap 1 p0" )
   h1n0 = CliModel.Int( "DFE Tap 1 n0" )
   h1p1 = CliModel.Int( "DFE Tap 1 p1" )
   h1n1 = CliModel.Int( "DFE Tap 1 n1" )

   def toModel( self, serdes ):
      super().toModel( serdes )
      self.dlevOdd = serdes.dlevOdd
      self.dlevEven = serdes.dlevEven
      self.passEq = serdes.passEq

      self.aeq = serdes.aeq

      # H2-9
      # H2 is 7 bits
      # H3,4 are 6 bits
      # H5 is 5 bits
      # H6-9 are 4 bits
      # These will be in the DFE taps above
      # The H1P and H1N taps are special
      # H1P_0 10 bits
      self.h1p0 = serdes.h1p0
      self.h1n0 = serdes.h1n0
      self.h1p1 = serdes.h1p1
      self.h1n1 = serdes.h1n1

      return self

class D5PhySerdesModel( CliModel.Model ):
   serdesStats = CliModel.Dict( keyType=int,
                                valueType=D5PhySerdesLaneModel,
                                help="A mapping of lanes to SerDes statistics" )
   _sortedSerdesStats = CliModel.List( valueType=int,
                                       help="Sorted SerDes statistics")
   def toModel( self, serdes ):
      for lane, stats in serdes.items():
         laneStats = D5PhySerdesLaneModel().toModel( stats )
         # XXX kewei: Remove serdesId once BUG336826 is resolved.
         self.serdesStats[ getattr( lane, "laneId", lane ) ] = laneStats
      return self

   def renderSerdesDetail( self ):
      pass
