#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.PimConfigCli as PimConfigCli
from CliPlugin.PimConfigCli import pimGenBidirectionalGuard
from CliToken.Pim import sparseModeMatcher, pimNode
from CliToken.Router import routerMatcherForConfig

#--------------------------------------------------------------------------------
# (config) [ no | default ] router pim bidirectional
#--------------------------------------------------------------------------------
class RouterPimBidirectionalCmd( CliCommand.CliCommandClass ):
   syntax = 'router pim bidirectional'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'pim': pimNode,
      'bidirectional': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
                          'bidirectional', helpdesc='Bidirectional mode PIM' ),
                          guard=pimGenBidirectionalGuard ),
   }
   handler = PimConfigCli.gotoRouterPimBidirBaseMode
   noOrDefaultHandler = PimConfigCli.deleteRouterPimBidirBaseMode

BasicCli.GlobalConfigMode.addCommandClass( RouterPimBidirectionalCmd )

#--------------------------------------------------------------------------------
# (config) [ no | default ] router pim
#--------------------------------------------------------------------------------
class RouterPimCmd( CliCommand.CliCommandClass ):
   syntax = 'router pim'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'pim': pimNode,
   }
   handler = PimConfigCli.gotoRouterPimMode
   noOrDefaultHandler = PimConfigCli.deleteRouterPimMode

BasicCli.GlobalConfigMode.addCommandClass( RouterPimCmd )

#--------------------------------------------------------------------------------
# (config) [ no | default ] router pim sparse-mode
#--------------------------------------------------------------------------------
class RouterPimSparseModeCmd( CliCommand.CliCommandClass ):
   syntax = 'router pim sparse-mode'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'pim': pimNode,
      'sparse-mode': sparseModeMatcher,
   }
   handler = PimConfigCli.gotoRouterPimSparseMode
   noOrDefaultHandler = PimConfigCli.deleteRouterPimSparseMode

BasicCli.GlobalConfigMode.addCommandClass( RouterPimSparseModeCmd )
