# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Toggles.GmpToggleLib

from CliPlugin import TechSupportCli
from CliPlugin.McastCommonCli import mcastv6RoutingSupportedGuard
from CliPlugin.MrouteCli import mcastFibIpv4SupportedGuard
from CliPlugin.PimShowCli import ipPimSupportedGuard, ipPimSupportedTechGuard
from CliPlugin.GmpShowTechCli import registerShowTechMulticast, ShowTechMulticastType

if Toggles.GmpToggleLib.toggleMulticastShowTechEnabled():
   TechSupportCli.registerShowTechSupportCmd(
      '2023-09-18 02:00:00',
      cmds=[ 'show tech-support multicast' ],
      cmdsGuard=lambda: ipPimSupportedTechGuard( mode=None, token=None ) is None )

   showTechPimv4Cmds = [ 'show pim ipv4 vrf {} neighbor',
                         'show pim ipv4 vrf {} interface',
                         'show pim ipv4 vrf {} rp',
                         'show pim ipv4 vrf {} sparse-mode join',
                         'show pim ipv4 vrf {} protocol counters' ]

   showTechPimv6Cmds = [ 'show pim ipv6 vrf {} neighbor',
                         'show pim ipv6 vrf {} protocol counters' ]

   showTechPimSummaryCmds = [ 'show pim evpn gateway dr' ]

   registerShowTechMulticast( showTechPimv4Cmds,
                              showTechMcastType=ShowTechMulticastType.vrf,
                              guard=mcastFibIpv4SupportedGuard )

   registerShowTechMulticast( showTechPimv6Cmds,
                              showTechMcastType=ShowTechMulticastType.vrf,
                              guard=mcastv6RoutingSupportedGuard )

   registerShowTechMulticast( showTechPimSummaryCmds,
                              showTechMcastType=ShowTechMulticastType.summary,
                              guard=mcastFibIpv4SupportedGuard )
else:
   TechSupportCli.registerShowTechSupportCmd(
      '2010-06-11 02:00:00',
      cmds=[ 'show pim ipv4 vrf all neighbor',
             'show pim ipv4 interface',
             'show ip pim rp',
             'show pim ipv4 sparse-mode join',
             'show ip pim config-sanity',
             'show pim ipv4 protocol counters' ],
      cmdsGuard=lambda: ipPimSupportedGuard( mode=None, token=None ) is None,
      summaryCmds=[ 'show pim ipv4 vrf all neighbor' ],
      summaryCmdsGuard=lambda: ipPimSupportedGuard( mode=None, token=None ) is None )

   TechSupportCli.registerShowTechSupportCmd(
      '2010-06-11 02:00:00',
      cmds=[ 'show pim ipv6 vrf all neighbor',
             'show pim ipv6 protocol counters' ],
      cmdsGuard=lambda: mcastv6RoutingSupportedGuard() is None,
      summaryCmds=[ 'show pim ipv6 vrf all neighbor' ],
      summaryCmdsGuard=lambda: mcastv6RoutingSupportedGuard() is None )

   TechSupportCli.registerShowTechSupportCmd(
      '2020-05-07 18:10:30',
      cmds=[ 'show pim evpn gateway dr',
         ],
      cmdsGuard=lambda: ipPimSupportedGuard( mode=None, token=None ) is None,
   )

