#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.PimCliLib
from CliPlugin.AclCli import standardIpAclNameMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.PimsmCliConfig as PimsmCliConfig
from CliPlugin.IpAddrMatcher import IpAddrMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.RouteMapCli as RouteMapCli
from CliToken.Pim import (
      fastRerouteMatcher,
      ssmMatcher,
      ssmRangeMatcher,
      thresholdMatcher,
)

#--------------------------------------------------------------------------------
# fast-reroute ACL
#--------------------------------------------------------------------------------
class FastRerouteAclnameCmd( CliCommand.CliCommandClass ):
   syntax = 'fast-reroute ACL'
   data = {
      'fast-reroute': fastRerouteMatcher,
      'ACL': standardIpAclNameMatcher,
   }

   handler = PimsmCliConfig.setIpPimsmFrrFilter

CliPlugin.PimCliLib.RouterPimSparseIpv4Modelet.\
   addCommandClass( FastRerouteAclnameCmd )

#--------------------------------------------------------------------------------
# [ no | default ] spt threshold THRESHOLD match list ACL
#--------------------------------------------------------------------------------
class SptThresholdCmd( CliCommand.CliCommandClass ):
   syntax = 'spt threshold THRESHOLD match list ACL'
   noOrDefaultSyntax = 'spt threshold THRESHOLD [ match list ACL ]'
   data = {
      'spt': 'Shortest path tree',
      'threshold': 'Switchover threshold',
      'THRESHOLD': thresholdMatcher,
      'match': 'Match on the following option',
      'list': 'ACL specifying groups threshold applies to',
      'ACL': standardIpAclNameMatcher,
   }

   handler = PimsmCliConfig.setPimsmSptThresh
   noOrDefaultHandler = PimsmCliConfig.noPimsmSptThresh

CliPlugin.PimCliLib.RouterPimSparseIpv4Modelet.addCommandClass( SptThresholdCmd )

#--------------------------------------------------------------------------------
# [ no | default ] ssm default source GROUP SOURCE
#--------------------------------------------------------------------------------
class SsmDefaultSourceCmd( CliCommand.CliCommandClass ):
   syntax = 'ssm default source ( GROUP | ( group filter PREFIX_LIST ) ) SOURCE'
   noOrDefaultSyntax = ( 'ssm default source '
                         '[ GROUP | ( group filter PREFIX_LIST ) [ SOURCE ] ]' )
   data = {
      'ssm': ssmMatcher,
      'default': 'Source-Specific Multicast default source',
      'source': 'Source-Specific Multicast default source',
      'GROUP': IpAddrMatcher( helpdesc='Multicast group address' ),
      'group': 'Multicast group configuration',
      'filter': 'Filter for multicast group mappings',
      'PREFIX_LIST': RouteMapCli.prefixListNameMatcher,
      'SOURCE': IpAddrMatcher( helpdesc='IPv4 address used as a source' ),
   }

   handler = PimsmCliConfig.setIpPimSsmConvert
   noOrDefaultHandler = PimsmCliConfig.noIpPimSsmConvert

CliPlugin.PimCliLib.RouterPimSparseIpv4Modelet.addCommandClass( SsmDefaultSourceCmd )

#--------------------------------------------------------------------------------
# ssm range ( standard | ACL )
#--------------------------------------------------------------------------------
class SsmRangeCmd( CliCommand.CliCommandClass ):
   syntax = 'ssm range ( standard | ACL )'
   data = {
      'ssm': ssmMatcher,
      'range': ssmRangeMatcher,
      'standard': 'Sets the SSM range to 232/8',
      'ACL': standardIpAclNameMatcher,
   }

   handler = PimsmCliConfig.setIpPimsmSsmFilter

CliPlugin.PimCliLib.RouterPimSparseIpv4Modelet.addCommandClass( SsmRangeCmd )
