#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliToken.Platform import platformMatcherForExec

slotnameMatcher = CliMatcher.PatternMatcher( pattern='^([a-zA-Z]+)[0-9/]+$',
                                              helpdesc='Name of module slot',
                                              helpname='SLOT' )

moduleMatcher = CliMatcher.KeywordMatcher( 'module',
                                           helpdesc='Platform module' )

#--------------------------------------------------------------------------------
# platform module SLOTNAME power-cycle [ enable checks ]
#--------------------------------------------------------------------------------
class PlatformModuleSlotnamePowerCycleCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME power-cycle [ enable checks ]'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'power-cycle' : 'Power cycle module',
      'enable': 'Enable checks for unstable shutdown behavior',
      'checks': 'Enable checks for unstable shutdown behavior',
   }
   hidden = True

   handler = "PlutoPlatformModuleCliHandler.doPowercycleModule"

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnamePowerCycleCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME remove... [ enable checks ]
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameRemoveCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME remove [ enable checks ]'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'remove' : 'Power cycle module and immediately place in to diags',
      'enable': 'Enable checks for unstable shutdown behavior',
      'checks': 'Enable checks for unstable shutdown behavior',
   }
   hidden = True

   handler = "PlutoPlatformModuleCliHandler.doRemoveModule"

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameRemoveCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME diags
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameDiagsCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME diags'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'diags' : 'Place module in to diags immediately',
   }
   hidden = True

   handler = "PlutoPlatformModuleCliHandler.doDiagModule"

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameDiagsCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME insert
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameInsertCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME insert'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'insert' : 'Insert module from diags',
   }
   hidden = True

   handler = "PlutoPlatformModuleCliHandler.doInsertModule"

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameInsertCmd )
