#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import ShowCommand
from CliPlugin.PlutoPlatformModuleCli import PlatformModules
from CliToken.Platform import platformMatcherForShow

#--------------------------------------------------------------------------------
# show platform module [ SLOTNAME | all ]
#--------------------------------------------------------------------------------
class PlatformModuleCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform module [ SLOTNAME ]'
   data = {
      'platform' : platformMatcherForShow,
      'module' : CliMatcher.KeywordMatcher( 'module',
                                            helpdesc='Platform module' ),
      'SLOTNAME' : CliMatcher.PatternMatcher( pattern='^([a-zA-Z]+)[0-9/]*$',
                                              helpdesc='Name of module slot, or all',
                                              helpname='SLOT' ),
   }
   hidden = True

   handler = "PlutoPlatformModuleCliHandler.doShowPlatformModule"
   cliModel = PlatformModules
   privileged = True

BasicCli.addShowCommandClass( PlatformModuleCmd )
