#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=ungrouped-imports

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand
import CliPlugin.PortSecCliHelpers as PortSecCliHelpers
import CliPlugin.VlanCli as VlanCli
import CliPlugin.TechSupportCli as TechSupportCli
from CliPlugin.IntfCli import Intf
from CliPlugin.PortSecCliHelpers import ( GeneralPortSecurityStatistics,
                                          GeneralPortSecurityVlanStatistics,
                                          PortSecurityAddresses,
                                          PortSecurityInterfaces )

guardVlanBasedPortSec = PortSecCliHelpers.guardVlanBasedPortSec
matcherPortSecurity = CliMatcher.KeywordMatcher( 'port-security',
      helpdesc='Show secure port information' )
matcherVlan = CliMatcher.KeywordMatcher( 'vlan',
      helpdesc='Show secure VLAN' )
nodeVlan = CliCommand.Node( matcher=matcherVlan,
      guard=guardVlanBasedPortSec )

#--------------------------------------------------------------------------------
# show port-security address (DEPRECATED)
#--------------------------------------------------------------------------------
class DeprecatedAddressCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-security address'
   data = {
      'port-security': matcherPortSecurity,
      'address': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'address',
                                             helpdesc='Show secure address' ),
                                  deprecatedByCmd='show port-security mac-address' ),
   }
   handler = PortSecCliHelpers.doShowPortSecurityAddress
   cliModel = PortSecurityAddresses

BasicCli.addShowCommandClass( DeprecatedAddressCmd )

#--------------------------------------------------------------------------------
# show port-security
#--------------------------------------------------------------------------------
class PortSecurityCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-security'
   data = {
      'port-security': matcherPortSecurity,
   }
   handler = PortSecCliHelpers.doShowPortSecurity
   cliModel = GeneralPortSecurityStatistics

BasicCli.addShowCommandClass( PortSecurityCmd )

#--------------------------------------------------------------------------------
# show port-security interface [ INTF1 ]
#--------------------------------------------------------------------------------
class PortSecurityInterfaceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-security interface [ INTF ]'
   data = {
      'port-security': matcherPortSecurity,
      'interface': 'Show secure interface',
      'INTF': Intf.rangeMatcher,
   }
   handler = PortSecCliHelpers.doShowPortSecurityInterface
   cliModel = PortSecurityInterfaces

BasicCli.addShowCommandClass( PortSecurityInterfaceCmd )

#--------------------------------------------------------------------------------
# show port-security mac-address
#--------------------------------------------------------------------------------
class PortSecurityMacAddressCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-security mac-address'
   data = {
      'port-security': matcherPortSecurity,
      'mac-address': 'Show secure address',
   }
   handler = PortSecCliHelpers.doShowPortSecurityAddress
   cliModel = PortSecurityAddresses

BasicCli.addShowCommandClass( PortSecurityMacAddressCmd )

#--------------------------------------------------------------------------------
# show port-security vlan [ VLANS ] [ interface INTFS ]
#--------------------------------------------------------------------------------
class PortSecurityVlanCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-security vlan [ VLANS ] [ interface INTFS ]'
   data = {
      'port-security': matcherPortSecurity,
      'vlan': nodeVlan,
      'VLANS': VlanCli.vlanSetMatcher,
      'interface': 'Show secure interface',
      'INTFS': Intf.rangeMatcher,
   }
   handler = PortSecCliHelpers.doShowPortSecurityVlan
   cliModel = GeneralPortSecurityVlanStatistics

BasicCli.addShowCommandClass( PortSecurityVlanCmd )

#--------------------------------------------------------------------------------
# Show Tech Commands
#--------------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
      '2021-04-13 15:00:00',
      cmds=[ 'show port-security' ] )
