#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.PowerCli as PowerCli # pylint: disable=consider-using-from-import
from CliPlugin.PowerCli import PowerSupplies, VoltageSensors, CurrentSensors
from CliToken.System import systemMatcherForShow

matcherDetail = CliMatcher.KeywordMatcher( 
      'detail', helpdesc='Show detailed system power status' )
matcherEnvironment = CliMatcher.KeywordMatcher( 
      'environment', helpdesc='Show system environment status' )
matcherPower = CliMatcher.KeywordMatcher( 
      'power', helpdesc='Show system power status' )
matcherVoltage = CliMatcher.KeywordMatcher( 
      'voltage', helpdesc='Show voltage sensor values' )
matcherCurrent = CliMatcher.KeywordMatcher( 
      'current', helpdesc='Show current sensor values' )

#--------------------------------------------------------------------------------
# show environment power
#--------------------------------------------------------------------------------
class EnvironmentPowerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
   }
   handler = PowerCli.showPower
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( EnvironmentPowerCmd )

#--------------------------------------------------------------------------------
# show environment power detail
#--------------------------------------------------------------------------------
class EnvironmentPowerDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power detail'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
      'detail': matcherDetail,
   }
   handler = PowerCli.showPowerDetail
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( EnvironmentPowerDetailCmd )

#--------------------------------------------------------------------------------
# show environment power voltage
#--------------------------------------------------------------------------------
class EnvironmentPowerVoltageCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power voltage'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
      'voltage': matcherVoltage,
   }
   handler = PowerCli.showPowerVoltage
   cliModel = VoltageSensors

BasicCli.addShowCommandClass( EnvironmentPowerVoltageCmd )

#--------------------------------------------------------------------------------
# show system environment power
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
   }
   handler = PowerCli.showPower
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( SystemEnvironmentPowerCmd )

#--------------------------------------------------------------------------------
# show system environment power detail
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power detail'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
      'detail': matcherDetail,
   }
   handler = PowerCli.showPowerDetail
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( SystemEnvironmentPowerDetailCmd )

#--------------------------------------------------------------------------------
# show system environment power voltage
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerVoltageCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power voltage'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
      'voltage': matcherVoltage,
   }
   handler = PowerCli.showPowerVoltage
   cliModel = VoltageSensors

BasicCli.addShowCommandClass( SystemEnvironmentPowerVoltageCmd )

#--------------------------------------------------------------------------------
# show system environment power current
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerCurrentCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power current'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
      'current': matcherCurrent,
   }
   handler = PowerCli.showPowerCurrent
   cliModel = CurrentSensors

BasicCli.addShowCommandClass( SystemEnvironmentPowerCurrentCmd )
