#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliModes
import CliCommand
import CliMatcher
import ShowCommand
from CliPlugin.SnmpCli import (
      snmpServerKwMatcher,
      snmpKwMatcher,
      mibKwMatcherForShow
      )

#--------------------------------------------------------------------------------
# show snmp mib qosmib counter-interval
#--------------------------------------------------------------------------------

class SnmpMibQosmibCounterIntervalCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show snmp mib qosmib counter-interval'
   data = {
      'snmp': snmpKwMatcher,
      'mib': mibKwMatcherForShow,
      'qosmib': 'Show SNMP QOS-MIB contents',
      'counter-interval': 'Show QOS-MIB counter update interval',
   }
   handler = "QosSnmpCliHandler.doShowQosMibCounterInterval"
   privileged = True
   cliModel = "QosSnmpCliModel.QosmibCounterIntervalModel"

BasicCli.addShowCommandClass( SnmpMibQosmibCounterIntervalCmd )

#--------------------------------------------------------------------------------
# snmp-server qosmib counter-interval UPDATE_INTERVAL
#--------------------------------------------------------------------------------
class SnmpServerQosmibCounterIntervalUpdateintervalCmd( CliCommand.CliCommandClass ):
   syntax = 'snmp-server qosmib counter-interval UPDATE_INTERVAL'
   noOrDefaultSyntax = 'snmp-server qosmib counter-interval ...'
   data = {
      'snmp-server': snmpServerKwMatcher,
      'qosmib': 'Set SNMP QOS-MIB parameters',
      'counter-interval': 'Set QOS-MIB counter update interval',
      'UPDATE_INTERVAL': CliMatcher.IntegerMatcher( 10, 600,
            helpdesc='update interval for refreshing QoS counters (in seconds)' ),
   }
   handler = "QosSnmpCliHandler.doUpdateQosMibCounterInterval"
   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass(
         SnmpServerQosmibCounterIntervalUpdateintervalCmd )
