#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliToken.Clear
from CliPlugin.VrfCli import VrfExprFactory
from CliPlugin.RadiusCli import radiusServerKwMatcher
import BasicCli
import LazyMount

radsecConfig = None

#-------------------------------------------------------------------------------
# "clear radius-server tls [ vrf <vrfName> ]" in enable mode
#-------------------------------------------------------------------------------

def clearRadiusTlsSessionForVrf( mode, vrf ):
   if vrf is not None:
      if vrf in radsecConfig.vrfConfig:
         radsecConfig.vrfConfig[ vrf ] += 1
      else:
         radsecConfig.vrfConfig[ vrf ] = 1
   else:
      radsecConfig.restartAll += 1

class ClearRadiusServerTlsCommand( CliCommand.CliCommandClass ):
   syntax = "clear radius-server tls [ VRF ]"
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'radius-server': radiusServerKwMatcher,
      'tls': 'TLS sessions',
      'VRF': VrfExprFactory( helpdesc='VRF for this Radius server' )
   }

   @staticmethod
   def handler( mode, args ):
      vrf = args.get( 'VRF', None )
      clearRadiusTlsSessionForVrf( mode, vrf )

BasicCli.EnableMode.addCommandClass( ClearRadiusServerTlsCommand )

def Plugin( entityManager ):
   global radsecConfig

   radsecConfig = LazyMount.mount( entityManager, "security/aaa/radsec/config",
                                   "Radsec::ConfigDir", "w" )
