# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import (
      Bool,
      Dict,
      Enum,
      Float,
      Int,
      List,
      Model,
      Submodel,
)
from CliPlugin.RcfCliLib import (
   rcfFunctionStatusHelp,
   RCF_FUNCTION_STATUS_DICT,
   RCF_FUNCTION_UPDATE_REASON_DICT,
)

##########
# Models for "show <agent> rcf <func-name>"
##########

class ShowAgentRcfMissingRefModel( Model ):
   srLabelRangeMissing = Bool(
      help='Indicate if SR label range is missing',
      optional=True
   )
   prefixListV4 = List(
      valueType=str,
      help='Missing reference to an IPv4 prefix list',
      optional=True
   )
   prefixListV6 = List(
      valueType=str,
      help='Missing reference to an IPv6 prefix list',
      optional=True
   )
   asPathList = List(
      valueType=str,
      help='Missing reference to an ASN list',
      optional=True
   )
   communityList = List(
      valueType=str,
      help='Missing reference to a community list',
      optional=True
   )
   extCommunityList = List(
      valueType=str,
      help='Missing reference to an extended community list',
      optional=True
   )
   largeCommunityList = List(
      valueType=str,
      help='Missing reference to a large community list',
      optional=True
   )
   roaTable = List(
      valueType=str,
      help='Missing reference to a ROA table',
      optional=True
   )

class ShowAgentRcfFunctionModel( Model ):
   status = Enum( values=list( RCF_FUNCTION_STATUS_DICT.values() ),
                  help=rcfFunctionStatusHelp )
   missingReferenceDetails = Submodel(
      ShowAgentRcfMissingRefModel,
      optional=True,
      help="Detail of missing reference lists"
   )

class ShowAgentRcfDetailFunctionModel( ShowAgentRcfFunctionModel ):
   lastUpdated = Float( help='Timestamp of most recent update' )
   updateCount = Int( help='Number of function updates' )
   lastUpdateReason = Enum( list( RCF_FUNCTION_UPDATE_REASON_DICT.values() ),
                            help="Reason for most recent update" )

class ShowAgentRcfModel( Model ):
   functions = Dict(
      keyType=str,
      valueType=ShowAgentRcfFunctionModel,
      help='Routing control function information, keyed by function name' )

class ShowAgentRcfDetailModel( Model ):
   functions = Dict(
      keyType=str,
      valueType=ShowAgentRcfDetailFunctionModel,
      help='Detailed routing control function information, keyed by function name' )
